.TH "hmmconvert" 1 "March 1998" "HMMER 2.0" "HMMER Manual"

.SH NAME
.TP 
hmmconvert - convert between profile HMM file formats

.SH SYNOPSIS
.B hmmconvert
.I [options]
.I oldhmmfile
.I newhmmfile

.SH DESCRIPTION

.B hmmconvert
reads an HMM file from
.I oldhmmfile
in any HMMER format, and writes it to a new file
.I newhmmfile 
in a new format.
.I oldhmmfile 
and 
.I newhmmfile
must be different files; you can't reliably overwrite 
the old file.
By default, the new HMM file is written in HMMER 2
ASCII format. 

Available formats are HMMER 2 ASCII (default), HMMER 2 binary
.I (-b)
GCG profile 
.I (-p)
, and Compugen XSW extended profile 
.I (-P).

.SH OPTIONS

.TP
.B -a 
Convert to HMMER 2 ASCII file. This is the default, so this option
is unnecessary.

.TP 
.B -b 
Convert to HMMER 2 binary file. 

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.TP
.B -p
Convert to GCG profile .prf format.

.TP 
.B -A
Append mode; append to
.I newhmmfile
rather than creating a new file. 

.TP
.B -F
Force; if 
.I newhmmfile
already exists, and
.I -A 
is not being used to append to the file,
hmmconvert will refuse to clobber the existing
file unless 
.I -F 
is used.

.TP
.B -P
Convert the HMM to Compugen XSW extended profile format,
which is similar to GCG profile format but has two
extra columns for delete-open and delete-extend costs.
(I do not believe that Compugen publicly supports this
format; it may be undocumented.)

.SH SEE ALSO

.PP
hmmalign(1), hmmbuild(1), hmmcalibrate(1),
hmmer(1), hmmemit(1), hmmpfam(1), hmmsearch(1)
.PP
User guide and tutorial: Userguide.ps
.PP
WWW: 
.B http://hmmer.wustl.edu/

.SH AUTHOR

This software and documentation is Copyright (C) 1992-1998 Washington
University School of Medicine.  It is freely distributable under terms
of the GNU General Public License. See COPYING in the source code
distribution for more details, or contact me.

.nf
Sean Eddy
Dept. of Genetics
Washington Univ. School of Medicine
4566 Scott Ave.
St Louis, MO 63110 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-7855
Email: eddy@genetics.wustl.edu
.fi


