/*
 * $Id: pgsql.c,v 1.25 1998/09/27 11:19:00 ch Exp $
 *
 * This source code is part of my universal C library "libch".
 * Copyright (C) 1998 by Christian Hammers <ch@westend.com>.
 *
 * This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include "libpq-fe.h"
#include "libch.h"

PGconn		*ch_pgsql_con;
PGresult	*ch_pgsql_result;

char	       *ch_pgsql_row_buf [CH_PGSQL_MAX_FIELDS+1]; 
int		ch_pgsql_row_i;

void ch_pgsql_open(char *name) {
	int	i;
	
	for (i=0; i<=CH_PGSQL_MAX_FIELDS; i++) {
		ch_pgsql_row_buf[i]=NULL;
	}

	ch_pgsql_con=PQsetdb("localhost",NULL,NULL,NULL,name);

	if (PQstatus(ch_pgsql_con) == CONNECTION_BAD) {
        	ch_panic("error opening pgsql connection: %s", 
			PQerrorMessage(ch_pgsql_con));
	}
}

void ch_pgsql_close() {
	PQfinish(ch_pgsql_con);
}

char *ch_pgsql_error() {
	return PQerrorMessage(ch_pgsql_con);
}

void ch_pgsql_query(char *query) {
	ch_pgsql_result=PQexec(ch_pgsql_con, query);
	if ((PQresultStatus(ch_pgsql_result) != PGRES_TUPLES_OK) &&
           (PQresultStatus(ch_pgsql_result) != PGRES_COMMAND_OK)) {
		ch_panic("ch_pgsql_query: ERROR at %s:\n%s\n",
			query,PQerrorMessage(ch_pgsql_con));
	}
} 

int ch_pgsql_quiet_query(char *query) {
	ch_pgsql_result=PQexec(ch_pgsql_con, query);
	if ((PQresultStatus(ch_pgsql_result) != PGRES_TUPLES_OK) &&
           (PQresultStatus(ch_pgsql_result) != PGRES_COMMAND_OK)) return 1;
	return 0; 
} 

int ch_pgsql_num_rows(PGresult *res) {
	return PQntuples(res);
}

PGresult *ch_pgsql_store_result() {
	int	i;

	for (i=0; i<PQnfields(ch_pgsql_result); i++) {
		if (ch_pgsql_row_buf[i]) {
			ch_panic("ch_pgsql_store_result: "
                               "you have to do a ch_sql_free_result() first !");
		}
	}
	ch_pgsql_row_i=0;
	return ch_pgsql_result;
}

ch_sql_row_t ch_pgsql_fetch_row(PGresult *result) {
	int	x;

	/* are my field assumptions too low ? */	
	if (PQnfields(result) > CH_PGSQL_MAX_FIELDS) {
		ch_panic("ch_pgsql_fetch_row: too much fields !");		
	}

	/* already returned last record ? */
	if (ch_pgsql_row_i >= PQntuples(result)) return NULL;

	/* free old data */ 
	for (x=0; x<=CH_PGSQL_MAX_FIELDS; x++) {
        	if (ch_pgsql_row_buf[x]) {
        		free(ch_pgsql_row_buf[x]);
        		ch_pgsql_row_buf[x]=NULL;
        	}
        }

	/* insert new data */	
        for (x=0; x<PQnfields(result); x++) {
              	ch_pgsql_row_buf[x]=malloc(PQgetlength(result,ch_pgsql_row_i,x)+1);
		strcpy(ch_pgsql_row_buf[x], PQgetvalue(result,ch_pgsql_row_i,x));
	}

	/* next time I will return the next row */
	ch_pgsql_row_i++;

	return ch_pgsql_row_buf;
}


char *ch_pgsql_fetch_element(PGresult *result, int row, int column) {
	return PQgetvalue(result, row, column);
}

void ch_pgsql_free_result(PGresult *result) {
	int	i;

	for (i=0; i<PQnfields(result); i++) {
		if (ch_pgsql_row_buf[i]) {
			free(ch_pgsql_row_buf[i]);
			ch_pgsql_row_buf[i]=NULL;
		}
/* ch_free(ch_pgsql_row_buf[i]); */
	}

	PQclear(result);
}
	
