/*
 * $Id: cgi.c,v 1.13 1998/10/01 21:27:34 ch Exp $
 *
 *
 * This source code is part of my universal C library "libch".
 * Copyright (C) 1998 by Christian Hammers <ch@westend.com>.
 *
 * This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *
 * History
 * 25.06.1998	Added ch_cgi_escape()
 * 25.06.1998	Fixed using ch_cgi_init() for starting via export QUERY_STRING
 * 16.02.1998	Extended ch_cgi_init() to use the program it as pipe.
 * 02.02.1998 	Renamed the project from libcgi to libch
 * 01.02.1998	added PID to cgi_debugfile name and remove it at cgi_done()
 * 20.01.1998	added cgi_malloc()	
 *
 *
 * Remember: /cgi-bin/test?aaa=1&bbb=2&ccc=3
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <strings.h>
#include "./libch.h"

char   *ch_cgi_s;		/* internal: the content string */
int	ch_cgi_len;		/* internal: the content-length */

/**                                                                     */
/**     void ch_cgi_panic(char *format, ...)                            */
/**                                                                     */
/**     Exits program with given string and back button                 */
/**                                                                     */
void ch_cgi_panic(char *format, ...) {
        va_list         ap;
        char            s[255];

        va_start(ap,format);
	vsprintf(s,format,ap); 
        va_end(ap);
	printf("<br>PANIC !<br>%s<br>",s);
	printf("<br><A HREF=\"%s\">back</A>",getenv("HTTP_REFERER"));
        fflush(stdout);

        exit(EXIT_FAILURE);
}
             
 
/**									*/
/**	void ch_cgi_init()				    		*/
/**									*/
/** 	Initialise the cgi routienes (gets the content string)		*/
/**	Try to get it non-cgi safe for debugging purposes.		*/
/**									*/
void ch_cgi_init() {
	char 	*rm, *qs;
	string	s;
	
	printf("Content-Type: text/html\n\n");

	/* to handle buggy/non-cgi calling w/o core dump */
	rm=getenv("REQUEST_METHOD"); if (!rm) rm="";
	qs=getenv("QUERY_STRING"); if (!qs) qs="";

	if (!strcmp(rm,"POST")) {
		/* post */
		if (getenv("CONTENT_LENGTH")) {
			ch_cgi_len=atoi(getenv("CONTENT_LENGTH"));
			if (ch_cgi_len==0) {
				ch_cgi_len=1;
			} else {
				ch_cgi_len+=2;
			}
		}
		ch_cgi_s=ch_malloc(ch_cgi_len); 
		fgets(ch_cgi_s, ch_cgi_len, stdin);
	} else if (strlen(qs)>0) {
		/* get */
		ch_cgi_len=strlen(qs);
		ch_cgi_s=ch_malloc(ch_cgi_len);
		strcpy(ch_cgi_s, qs);
	} else {
		/* stdin */
		printf("Input CGI parameter string !\n");
		fgets(s,sizeof(s),stdin);
		ch_cgi_len=strlen(s);
		ch_cgi_s=ch_malloc(ch_cgi_len);
		strncpy(ch_cgi_s, s, ch_cgi_len);
	}
	if (ch_cgi_s[strlen(ch_cgi_s)-1]=='\n') 
	    ch_cgi_s[strlen(ch_cgi_s)-1]='\0';
}

/**									*/
/** 	void ch_cgi_dump()						*/
/**									*/
/**	Dumps the ch_cgi_s string with all cgi values (DEBUG)		*/
/**									*/
void ch_cgi_dump() {
	string	s;

	sprintf(s,"<br>\nCH_CGI_DUMP=\"%s\"\n<br>\n",ch_cgi_s);
	___(s);
	printf("%s",s);
}

/**									*/
/**	Translates '+'  to ' ' and "%4D" to (char)0x4d			*/
/**									*/
char *ch_cgi_unescape(char *s) {
	int	i=0,ii=0;

	/* decode non-ascii chars */
	for (i=0,ii=0; s[ii]; i++,ii++) {
		if ((s[i]=s[ii])=='%') {
			s[i] = s[ii+1]>='A' ? s[ii+1]-'A'+10 : s[ii+1]-'0';
			s[i] *= 16;
			s[i] += s[ii+2]>='A' ? s[ii+2]-'A'+10 : s[ii+2]-'0';
			ii+=2;
		}
	}
	s[i]='\0';

	/* decode plus */
	for (i=0; s[i]; i++) if (s[i]=='+') s[i]=' ';	
	
	return s;
}

/**									*/
/** 	Returns the value of the parameter with the given name.     	*/
/**	If the name is non existent "" is returned.      		*/
/**									*/
void ch_cgi_get_value(char *name, char *buffer, int bufsize) {	
	int	i=0;
	int	li,ri;
	char 	*left	= ch_malloc(ch_cgi_len); 
	char	*right	= ch_malloc(ch_cgi_len);

	/* Nasty coderz out there ? */
	if ((buffer==NULL) || (bufsize<1)) {
		ch_panic("ch_cgi_get_value: %p,%d",buffer,bufsize);
	}

	/* Beware of the wulf. */
	if ((ch_cgi_s==NULL) || (ch_cgi_s[0]=='\0')) {
		strcpy(buffer,"");
		return;
	}
	
	/* do parsing */
	while (ch_cgi_s[i]!='\0') {
		strcpy(left,""); li=0;
		strcpy(right,""); ri=0;
		/* name */
		while (index("=\0",ch_cgi_s[i])==NULL) {
			left[li++]=ch_cgi_s[i++];
		}
		left[li]='\0'; i++;
		/* value */
		while (!index("&\0",ch_cgi_s[i])) {
			right[ri++]=ch_cgi_s[i++];
		}
		right[ri]='\0'; 
		/* that's all */
		if (ch_cgi_s[i]!='\0') i++;
		if (!strcmp(left,name)) {
			ch_cgi_unescape(right);
			if (strlen(right)+1>bufsize) {
				ch_panic("ch_cgi_get_value: buffer too small");
			}
			strcpy(buffer,right);
			return;
		}
	}
	strcpy(buffer,"");
	return;
}

/**									*/
/** 	Retruns 0 if value is NOT set else 1				*/
/**									*/
int ch_cgi_isset_value(char *name) {
	string 	s;

	ch_cgi_get_value(name,s,sizeof(s));
	return ( strlen(s) ? 1 : 0 );
}

