/* disk.h: low-level access functions to the disk
 *
 * Copyright (C) 1995-97 Roman Hodek <Roman.Hodek@informatik.uni-erlangen.de>
 *               1996-97 Michael Schlueter <schlue00@marvin.informatik.uni-dortmund.de>
 *
 * This program is free software.  You can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation: either version 2 or
 * (at your option) any later version.
 *
 */

#ifndef _disk_h
#define _disk_h

/* $Id: disk.h,v 1.3 1997/06/22 10:37:15 rnhodek Exp $
 *
 * $Log: disk.h,v $
 * Revision 1.3  1997/06/22 10:37:15  rnhodek
 * Added msread, mswrite for moving partitions
 *
 * Revision 1.2  1997/06/21 20:47:42  rnhodek
 * Added RCS keywords
 *
 * Revision 1.1  1997/06/11 14:36:35  rnhodek
 * branches:  1.1.1;
 * Initial revision
 * 
 * Revision 1.1.1.1  1997/06/11 14:36:35  rnhodek
 * Started using CVS for atafdisk
 *
 */

/***************************** Prototypes *****************************/

int sseek( unsigned int fd, unsigned long s );
int sseek( unsigned int fd, unsigned long s );
void sread( char *buffer, unsigned long secno );
int msread( char *buffer, unsigned long secno, unsigned n );
void dump_sector( unsigned long sec, unsigned char *buf );
void swrite( char *buf, unsigned long secno );
int dangerous_write( int fd, char *buf, unsigned long secno );
int mswrite( char *buf, unsigned long secno, unsigned n );

/************************* End of Prototypes **************************/

#endif  /* _disk_h */
