#!/bin/sh
# Check to see if all the needed packages are in the archive.
# Enrique Zanardi, 1998
# This is free software under the GNU General Public License.

if [ $# != 1 ]; then
echo "Usage: "$0" archive" 1>&2
        cat 1>&2 << EOF

        archive: the directory containing the Debian binary packages.
EOF
        exit -1
fi

# Set this to the location of the package archive.
archive=$1

export arch="`dpkg --print-architecture`"

rootscripts=`pwd`/scripts/rootdisk
basescripts=`pwd`/scripts/basedisks

rootfiles="$rootscripts/EXTRACT_LIST_all \
        $rootscripts/EXTRACT_LIST_${arch}"
basefiles="$basescripts/PACKAGES_all \
        $basescripts/PACKAGES_${arch} \
        $basescripts/PARTIAL_PACKAGES_all \
        $basescripts/PARTIAL_PACKAGES_${arch}"

. common.sh

exit=false

for i in $rootfiles $basefiles; do
        if [ ! -f $i ]; then
                echo "Can't open $i"
                exit=true
        fi
done
if $exit; then
        exit -1
fi

exit=false

# Check to see if all the needed packages are in the archive.
echo "Checking packages needed in the root disk:"
PACKAGE_PATHS=`make_paths \`cat $rootfiles\``
if [ $? -ne 0 ]; then
        exit=true;
fi
echo "Checking packages needed in the base system:"
PACKAGE_PATHS=`make_paths \`cat $basefiles\``
if [ $? -ne 0 ]; then
        exit=true;
fi

if $exit; then
	exit -1
fi

