.TH EXPORTS 5 "Jan 23, 1993"
.UC 5
.SH NAME
exports \- NFS file systems being exported
.SH SYNOPSIS
.B /etc/exports
.SH DESCRIPTION
The file
.I /etc/exports
serves as the access control list for file systems which may be
exported to NFS clients.  It is used by both the NFS mount daemon,
.IR mountd (8)
and the NFS file server daemon
.IR nfsd (8).
.PP
The file format is similar to the SunOS
.I exports
file, except that several additional options are permitted.  Each line
contains a mount point and a list of machine or netgroup names allowed
to mount the file system at that point.  An optional parenthesized list
of mount parameters may follow each machine name.  Blank lines are
ignored, and a # introduces a comment to the end of the line. Entries may
be continued across newlines using a backslash.
.PP
.SS Machine Name Formats
NFS clients may be specified in a number of ways:
.IP "single host
This is the most common format. You may specify a host either by an
abbreviated name recognizued be the resolver, the fully qualified domain
name, or an IP address.
.IP "netgroups
NIS netgroups may be given as
.IR @group .
Only the host part of all
netgroup members is extracted and added to the access list. Empty host
parts or those containing a single dash (\-) are ignored.
.IP "wildcards
Machine names may contain the wildcard characters \fI*\fR and \fI?\fR.
This can be used to make the \fIexports\fR file more compact; for instance,
\fI*.cs.foo.edu\fR matches all hosts in the domain \fIcs.foo.edu\fR. However,
these wildcard characters do not match the dots in a domain name, so the
above pattern does not include hosts such as \fIa.b.cs.foo.edu\fR.
.IP "IP networks
You can also export directories to all hosts on an IP (sub-) network
simultaneously. This is done by specifying an IP address and netmask pair
as
.IR address/netmask .
.PP
.SS General Options
.IR mountd " and " nfsd
understand the following export options:
.TP
.IR secure "\*d
This option requires that requests originate on an internet port less
than IPPORT_RESERVED (1024). This option is on by default. To turn it
off, specify
.IR insecure .
.TP
.IR ro
Allow only read-only requests on this NFS volume. The default is to
allow write requests as well, which can also be made explicit by using
the
.IR rw " option.
.TP
.I noaccess
This makes everything below the directory inaccessible for the named
client.  This is useful when you want to export a directory hierarchy to
a client, but exclude certain subdirectories. The client's view of a
directory flagged with noaccess is very limited; it is allowed to read
its attributes, and lookup `.' and `..'. These are also the only entries
returned by a readdir.
.TP
.IR link_relative
Convert absolute symbolic links (where the link contents start with a
slash) into relative links by prepending the necessary number of ../'s
to get from the directory containing the link to the root on the
server.  This has subtle, perhaps questionable, semantics when the file
hierarchy is not mounted at its root.
.TP
.IR link_absolute
Leave all symbolic link as they are. This is the default operation.
.SS User ID Mapping
.PP
.I nfsd
bases its access control to files on the server machine on the uid and
gid provided in each NFS RPC request. The normal behavior a user would
expect is that she can access her files on the server just as she would
on a normal file system. This requires that the same uids and gids are
used on the client and the server machine. This is not always true, nor
is it always desirable.
.PP
Very often, it is not desirable that the root user on a client machine
is also treated as root when accessing files on the NFS server. To this
end, uid 0 is normally mapped to a different id: the so-called
anonymous or
.I nobody
uid. This mode of operation (called `root squashing') is the default,
and can be turned off with
.IR no_root_squash .
.PP
By default,
.I nfsd
tries to obtain the anonymous uid and gid by looking up user
.I nobody
in the password file at startup time. If it isn't found, a uid and gid
of -2 (i.e. 65534) is used. These values can also be overridden by
the
.IR anonuid " and " anongid
options.
.PP
In addition to this, 
.I nfsd
lets you specify arbitrary uids and gids that should be mapped to user
nobody as well. Finally, you can map all user requests to the
anonymous uid by specifying the
.IR all_squash " option.
.PP 
For the benefit of installations where uids differ between different
machines, 
.I nfsd
provides a way to dynamically map server uids to client uids and vice versa.
This is enabled with the 
.I map_daemon
option, and uses the UGID RPC protocol. For this to work, you have to run
the
.IR ugidd (8)
mapping daemon on the client host.
.PP
Here's the complete list of mapping options:
.TP
.IR root_squash
Map requests from uid/gid 0 to the anonymous uid/gid. Note that this does
not apply to any other uids that might be equally sensitive, such as user
.IR bin .
.TP
.IR no_root_squash
Turn off root squashing. This option is mainly useful for diskless clients.
.TP
.IR squash_uids " and " squash_gids
This option specifies a list of uids ir gids that should be subject to
anonymous mapping. A valid list of ids looks like this:
.IP
.IR squash_uids=0-15,20,25-50
.IP
Usually, your squash lists will look a lot simpler.
.TP
.IR all_squash
Map all uids and gids to the anonymous user. Useful for NFS-exported
public FTP directories, news spool directories, etc. The opposite option
is 
.IR no_all_squash ,
which is the default setting.
.TP
.IR map_daemon
This option turns on dynamic uid/gid mapping. Each uid in an NFS request
will be translated to the equivalent server uid, and each uid in an
NFS reply will be mapped the other way round. This option requires that
.IR rpc.ugidd (8)
runs on the client host. The default setting is
.IR map_identity ,
which leaves all uids untouched. The normal squash options apply regardless
of whether dynamic mapping is requested or not.
.TP
.IR anonuid " and " anongid
These options explicitly set the uid and gid of the anonymous account.
This option is primarily useful for PC/NFS clients, where you might want
all requests appear to be from one user. As an example, consider the
export entry for
.B /home/joe
in the example section below, which maps all requests to uid 150 (which
is supposedly that of user joe).
.IP
.SH EXAMPLE
.PP
.nf
.ta +3i
# sample /etc/exports file
/               master(rw) trusty(rw,no_root_squash)
/projects       proj*.local.domain(rw)
/usr            *.local.domain(ro) @trusted(rw)
/home/joe       pc001(rw,all_squash,anonuid=150,anongid=100)
/pub            (ro,insecure,all_squash)
/pub/private    (noaccess)
.fi
.PP
The first line exports the entire filesystem to machines master and trusty.
In addition to write access, all uid squashing is turned off for host
trusty. The second and third entry show examples for wildcard hostnames
and netgroups (this is the entry `@trusted'). The fourth line shows the
entry for the PC/NFS client discussed above. Line 5 exports the
public FTP directory to every host in the world, executing all requests
under the nobody account. The
.I insecure 
option in this entry also allows clients with NFS implementations that
don't use a reserved port for NFS. The last line denies all NFS clients
access to the private directory.
.SH CAVEATS
Unlike other NFS server implementations, this
.I nfsd
allows you to export both a directory and a subdirectory thereof to
the same host, for instance 
.IR /usr " and " /usr/X11R6 .
In this case, the mount options of the most specific entry apply. For
instance, when a user on the client host accesses a file in 
.IR /usr/X11R6 ,
the mount options given in the 
.I /usr/X11R6 
entry apply. This is also true when the latter is a wildcard or netgroup
entry.
.SH FILES
/etc/exports
.SH DIAGNOSTICS
An error parsing the file is reported using syslogd(8) as level NOTICE from
a DAEMON whenever nfsd(8) or mountd(8) is started up.  Any unknown
host is reported at that time, but often not all hosts are not yet known
to named(8) at boot time, thus as hosts are found they are reported
with the same syslogd(8) parameters.
.SH SEE ALSO
mountd(8), nfsd(8)
