$! Makefile for VMS
$!
$! Parameter (maximal one at once):
$!	link	: links fudgit
$!	fudgit	: compiles and links fudgit (not readline)
$!	readline: compiles readline and builds library
$!	'C-file': compiles 'C-file'
$! without parameter : make all
$! Example: '@makevms math.c' compiles math.c
$
$! for gcc set CCPROG:=gcc, LINKLIBS:=,gnu_cc:[000000]gcclib/lib
$! but gcc cannot handle so much defines.
$! you can remove VOID_SIGHANDLER,NOUNISTD_H,NOMALLOC_H
$! remove also GNU_TERMCAP,getenv and compile readline separately.
$! but that is still too much.
$! Make therefore the scanfile gcc_scanfile.h (See the file [-]Installation).
$ CCPROG:=cc !gcc
$ CFLAGS:=/incl=([.readline])!/noopt/debug
$ LINKFLAGS :=!/debug
$ LINKLIBS :=!,gnu_cc:[000000]gcclib/lib !for gcc
$ LIBREADLINE:=,sys$disk:[.readline]readline/lib
$ LIBTERMCAP:=,sys$disk:[.termcap]termcap/lib
$ define sys sys$library ! only for cc
$ DEFINES="/define=(""VERSION=""""2.3.4"""""",""DATE="""""+f$time()+""""""""+-
	",VOID_SIGHANDLER,NOUNISTD_H,NOMALLOC_H"+-
	",CODETYPE,""Code=void"",USE_GETCWD,NOGAMMA,NOTRUNC"+-
	",NORINT,NOCBRT,NOHYP_TRIGO,NODRAND48,NOJN_YN,NOY0_Y1"+-
	",NOMALLINFO,MACROPOP,""system=vms_system"""+-
	",GNU_TERMCAP,""getenv=vms_getenv"")/G_FLOAT"
$! DEFINES for gcc: to use it make a scanfile 'gcc_scanfile.h' with the defines
$! see also '[-]Installation'
$! DEFINES="/G_FLOAT/SCAN="+f$directory()+"gcc_scanfile.h/define=(""VERSION=""""2.3.4"""""",""DATE="""""+f$time()+""""""")"
$ CC=f$string(CCPROG + DEFINES + CFLAGS)
$ LINK:=link
$
$! ------------- end of definitions ------------
$! p=f$environment("PROTECTION")
$! set protection=(owner:rwed)/default
$
$ if p1 .eqs. "READLINE"
$ then
$   gosub readline
$   goto ende
$ endif
$ if p1 .eqs. "LINK" then goto link
$ if p1 .eqs. "FUDGIT" then goto fudgit
$ if p1 .nes. ""
$ then
$   'CC 'p1 'p2 'p3 'p4 'p4 'p6 'p7 'p8 'p9
$   goto ende
$ endif
$
$! -------- readline ------------
$ gosub readline
$
$! ----- alloca -------
$fudgit:
$! Only needed if CC not gcc
$ 'CC alloca.c
$
$! -------- Fudgit ----------
$ bison/yacc/defines parse.y
$ edit/edt/command=sys$input/nojournal y_tab.c
set search EXACT
substitute /yy/Ft_mathyy/ WHOLE /NOTYPE
write mathparse.c
quit
$ edit/edt/command=sys$input/nojournal y_tab.h
set search EXACT
substitute /yy/Ft_mathyy/ WHOLE /NOTYPE
write math_tab.h
quit
$
$ 'CC fudgit.c
$ 'CC mathparse.c
$ 'CC alloc.c
$ 'CC setshow.c
$ 'CC vgetargp.c
$ 'CC plot.c
$ 'CC fits.c
$ 'CC fit.c
$ 'CC svdfit.c
$ 'CC medfit.c
$ 'CC help.c
$ 'CC mrqmin.c
$ 'CC code.c
$ 'CC math.c
$ 'CC extramath.c
$ 'CC lexi.c
$ 'CC init.c
$ 'CC fft.c
$ 'CC macro.c
$ 'CC minit.c
$ 'CC spline.c
$ 'CC readline2.c
$ 'CC chd.c
$ 'CC if.c
$ 'CC strings.c
$ 'CC vms.c
$ 'CC command.c
$
$! ---- link it -----
$link:
$! del scratch:[kr]fudgit.exe;*
$ 'LINK' 'LINKFLAGS' /exe=fudgit.exe -
	fudgit,mathparse,alloc,setshow,vgetargp,plot,fits,fit,svdfit,medfit,-
	help,mrqmin,command,code,math,extramath,lexi,init,fft,-
	macro,minit,spline,readline2,chd,alloca,if,strings,vms -
	'LIBREADLINE' 'LINKLIBS' 'LIBTERMCAP', -
	sys$input/option
sys$share:vaxcrtlg.exe/share
$
$
$ende:
$! set protection=('p')/default
$ exit
$
$! ---- readline ---
$readline:
$ set default [.readline]
$ 'CC readline.c
$ 'CC history.c
$ 'CC funmap.c
$ 'CC keymaps.c
$ 'CC vmsfunc.c
$ library/create readline/object readline,history,funmap,keymaps,vmsfunc
$ set default [-]
$ return
