/*
 * Copyright (C) 1992 by Software Research Associates, Inc.
 *	Author:	Y. Kawabe <kawabe@sra.co.jp>
 *
 * Permission to use, copy, modify, and distribute, and sell this software
 * and its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Software Research Associates
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 */

#ifndef nls_wregexp_h
#define nls_wregexp_h

#include <NLS/enter-scope.h>

class WString;
class WRegexpRep;

class WRegexp {
  public:
    WRegexp();
    WRegexp(const char*);
    WRegexp(const WString&);
    ~WRegexp();
    
    int Match(const WString& text, int index);
    int Search(const WString& text, int index, int range);
    int BeginningOfMatch(int subexp = 0) const;
    int EndOfMatch(int subexp = 0) const;
    const char* ErrorString() const;

  public:
    static WRegexp* Word ();

  private:
    WString* pattern_;
    WRegexpRep* rep_;
};

#endif
