/* LOCKVC Version 3.4 (c) 1994,1995,1997 by Matthias Straub */
/* Original code written by Matthias Straub */
/* 'Dotmorph' written by Lars Johannsen and Matthias Straub */
/* shadow-password option added by Ed Beaumont */
/* fixed-point math derived from a lockvc1.7-patch by Jeff Epler */
/* this file was released under GPL */
/* see COPYING for details */

		
#define MAXNUMSTARS 3000
#define SIZE 32768       
#define DIST 32768             /* should be a power of 2 for speed */
#define SCRX 320               /* .EQ. vga-mode */
#define SCRY 240               /* .EQ. vga-mode */

#define FPBITS 10
#define FM(x,y) (((x)*(y))>>FPBITS)
#define FM3(x,y,z) (((x)*(y)*(z))>>(2*FPBITS))
#define SIN(x) (feld->sintab[(x)&1023])
#define COS(x) SIN(x+256)
#define OBJS 9
#define MORPHS 15
#define MTIME 64

#define PLAIN 0
#define ATOM 1
#define RANDOM 2
#define SPHERE 3
#define TORUS 4
#define KEGEL 5
#define TORBALLS 6
#define FOURBALL 7
#define FOURTORUS 8

#include <signal.h>
#include <unistd.h> 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <vga.h>
#include <termio.h>
     


struct mfield 
{
    char page;
    int offset; 
    int numstars;
    int xr[MAXNUMSTARS];
    int yr[MAXNUMSTARS];
    int zr[MAXNUMSTARS];
    int xo[OBJS] [MAXNUMSTARS];
    int yo[OBJS] [MAXNUMSTARS];
    int zo[OBJS] [MAXNUMSTARS];
    int xmo[MORPHS] [MAXNUMSTARS];
    int ymo[MORPHS] [MAXNUMSTARS];
    int zmo[MORPHS] [MAXNUMSTARS];
    
    int xbuf[2] [MAXNUMSTARS];
    int ybuf[2] [MAXNUMSTARS];
    int sintab[1024];
    int s,t,u;	 
    int mtable;
    int IS11,IS12,IS13,IS21,IS22,IS23,IS31,IS32,IS33; 	
};

void plotcdots(int,struct mfield *feld);
void restore(int,struct mfield *feld);
void create_atom(int nr, int start, int length,struct mfield *feld);
void create_kegel(int nr, int start, int length, int radius, int hi,struct mfield *feld);
void create_sphere( int nr, int start, int length, int radius,struct mfield *feld);
void create_torus(int nr, int start, int length, int ra, int rb,struct mfield *feld); 
void create_random(int nr, int start, int length,struct mfield *feld);
void create_plain(int nr, int start, int length, int xlong, int  zlong,struct mfield *feld);
void move_object(int nr, int start, int length, int xa, int ya, int za,struct mfield *feld);


void mmksintab(struct mfield *feld)
{        
    int i;
    for(i=0;i<1024;i++)
    {
	feld->sintab[i]=(int)(sin(i*M_PI*2.0/1024)*1024);
    }
}

void domtable(int num,int from, int to, struct mfield *feld)
     {
	int i;
	for(i=0;i<feld->numstars;i++)
	    {
		feld->xmo[num] [i]=(feld->xo[to][i]-feld->xo[from][i])/MTIME;
		feld->ymo[num] [i]=(feld->yo[to][i]-feld->yo[from][i])/MTIME;
		feld->zmo[num] [i]=(feld->zo[to][i]-feld->zo[from][i])/MTIME;
	    }
     }

void minitfield(struct mfield *feld) 
    {
	int i;
	create_plain(PLAIN,0,feld->numstars,SIZE,SIZE,feld);
	move_object(PLAIN,0,feld->numstars,0,-SIZE/3,0,feld);
	
	create_atom(ATOM,0,feld->numstars,feld);
	
	create_random(RANDOM,0,feld->numstars,feld);

	create_sphere(SPHERE,0,feld->numstars,(SIZE/2),feld);
	
	create_torus(TORUS,0,feld->numstars,(SIZE/2),(SIZE/5),feld);
	
	create_torus(FOURTORUS,0           ,feld->numstars/4,SIZE/3,SIZE/6,feld);
	create_torus(FOURTORUS,feld->numstars/4  ,feld->numstars/4,SIZE/3,SIZE/6,feld);
	create_torus(FOURTORUS,feld->numstars/2  ,feld->numstars/4,SIZE/3,SIZE/6,feld);
	create_torus(FOURTORUS,feld->numstars/4*3,feld->numstars/4,SIZE/3,SIZE/6,feld);
	move_object(FOURTORUS,0           ,feld->numstars/4,0,SIZE/3,0,feld);
	move_object(FOURTORUS,feld->numstars/4  ,feld->numstars/4,0,SIZE/6,0,feld);
	move_object(FOURTORUS,feld->numstars/2  ,feld->numstars/4,0,-SIZE/6,0,feld);
	move_object(FOURTORUS,feld->numstars/4*3,feld->numstars/4,0,-SIZE/3,0,feld);
	move_object(FOURTORUS,0           ,feld->numstars  ,SIZE/2,0,0,feld);
	
	create_kegel(KEGEL,0,feld->numstars,(SIZE/2),SIZE,feld);
	move_object(KEGEL,0,feld->numstars,0,-SIZE/2,0,feld);
	
	create_sphere(TORBALLS,0         ,feld->numstars/4,SIZE/3,feld);
	create_sphere(TORBALLS,feld->numstars/4,feld->numstars/4,SIZE/3,feld);
	create_torus (TORBALLS,feld->numstars/2,feld->numstars/2,SIZE/2,SIZE/8,feld);
	move_object(TORBALLS,0,feld->numstars/4,0,-SIZE/3,0,feld);
	move_object(TORBALLS,feld->numstars/4,feld->numstars/4,0,SIZE/3,0,feld);
	
	create_sphere(FOURBALL,0           ,feld->numstars/4,SIZE/3,feld);
	create_sphere(FOURBALL,feld->numstars/4  ,feld->numstars/4,SIZE/3,feld);
	create_sphere(FOURBALL,feld->numstars/2  ,feld->numstars/4,SIZE/3,feld);
	create_sphere(FOURBALL,feld->numstars/4*3,feld->numstars/4,SIZE/3,feld);
	move_object(FOURBALL,0           ,feld->numstars/4,SIZE/2,0,0,feld);
	move_object(FOURBALL,feld->numstars/4  ,feld->numstars/4,-SIZE/2,0,0,feld);
	move_object(FOURBALL,feld->numstars/2  ,feld->numstars/4,0,SIZE/2,0,feld);
	move_object(FOURBALL,feld->numstars/4*3,feld->numstars/4,0,-SIZE/2,0,feld);
	
	/* morphtables */
	
	for (i=0;i<feld->numstars;i++) 
	  {
	     feld->xmo[0] [i]=0;
	     feld->ymo[0] [i]=0;
	     feld->zmo[0] [i]=0;
	  }
#define NOP 0 
	domtable(1,ATOM,PLAIN,feld);
#define ATOM2PLAIN 1 
	domtable(2,PLAIN,RANDOM,feld);
#define PLAIN2RANDOM 2
	domtable(3,RANDOM,PLAIN,feld);
#define RANDOM2PLAIN 3
	domtable(4,PLAIN,SPHERE,feld);
#define PLAIN2SPHERE 4
	domtable(5,SPHERE,PLAIN,feld);
#define SPHERE2PLAIN 5
	domtable(6,SPHERE,TORUS,feld);
#define SPHERE2TORUS 6
	domtable(7,TORUS,SPHERE,feld);
#define TORUS2SPHERE 7
	domtable(8,SPHERE,KEGEL,feld);
#define SPHERE2KEGEL 8
	domtable(9,KEGEL,TORBALLS,feld);
#define KEGEL2TORBALLS 9
	domtable(10,TORBALLS,RANDOM,feld);
#define TORBALLS2RANDOM 10
	domtable(11,SPHERE,FOURBALL,feld);
#define SPHERE2FOURBALL 11
	domtable(12,FOURBALL,PLAIN,feld);
#define FOURBALL2PLAIN 12
	domtable(13,FOURBALL,FOURTORUS,feld);
#define FOURBALL2FOURTORUS 13
	domtable(14,FOURTORUS,FOURBALL,feld);
#define FOURTORUS2FOURBALL 14	
	
	/* init */
	
	restore(ATOM,feld);
     }

void minitpalette() 
     {
	int j;
	for (j=0;j<32;j++)
	  {
	     vga_setpalette(j,2*j,2*j,2*j);
	     vga_setpalette(j+32,0,0,2*j);
	     vga_setpalette(j+64,0,2*j,2*j);
	     vga_setpalette(j+96,2*j,0,0);
	     vga_setpalette(j+128,2*j,2*j,2*j);
	     vga_setpalette(j+160,2*j,0,2*j);
	     vga_setpalette(j+192,0,2*j,0);
	     vga_setpalette(j+224,2*j,2*j,0);
	  }
     }

void plotdots(struct mfield *feld)
     {
	int i,x2,y2,z2,base;


		
/* looks weird, doesn't it? */
/* it's just the */
/* product of 3 less */
/* spectacular matrices */
/* that's what one year */
/* linear algebra class */
/* was for */              
       feld->IS11 = FM(COS(feld->s),COS(feld->t));
       feld->IS12 = FM(SIN(feld->s),COS(feld->t));
       feld->IS13 = -SIN(feld->t);
       feld->IS21 = -FM(SIN(feld->s),COS(feld->u))+FM3(COS(feld->s),SIN(feld->t),SIN(feld->u));
       feld->IS22 = FM(COS(feld->s),COS(feld->u))+FM3(SIN(feld->s),SIN(feld->t),SIN(feld->u));
       feld->IS23 = FM(COS(feld->t),SIN(feld->u));
       feld->IS31 = FM(SIN(feld->s),SIN(feld->u))+FM3(COS(feld->s),SIN(feld->t),COS(feld->u));
       feld->IS32 = -FM(COS(feld->s),SIN(feld->u))+FM3(SIN(feld->s),SIN(feld->t),COS(feld->u));
       feld->IS33 = FM(COS(feld->t),COS(feld->u));

	feld->page=1-feld->page;
	feld->offset=SCRY-feld->offset;
	vga_setdisplaystart((SCRY-feld->offset)*SCRX); 
	vga_waitretrace();
	
	vga_setcolor(0);              
	for (i=0;i<feld->numstars;i++)
	  {
	     x2=feld->xbuf[feld->page] [i];
	     y2=feld->ybuf[feld->page] [i];
	     if (x2<SCRX && y2 < (SCRY+feld->offset) && x2>=0 && y2 >= feld->offset)
	       {
		  vga_drawpixel(x2,y2);
	       }
	  }
	for(base=0;base<8;base++)
	  {
	    plotcdots(base,feld);
	  }
   }

void plotcdots(int base,struct mfield *feld)
   {
	int i,q,qq,x2,y2,z2,xl,yl;

	int cbase;
	cbase=16+base*32;
	for (i=base*feld->numstars/8;i<((base+1)*feld->numstars/8);i++) 
	  {
	     feld->xr[i]+=feld->xmo[feld->mtable][i];
	     feld->yr[i]+=feld->ymo[feld->mtable][i];
	     feld->zr[i]+=feld->zmo[feld->mtable][i];
	     z2 = (feld->IS13*feld->xr[i]+feld->IS23*feld->yr[i]+feld->IS33*feld->zr[i])>>FPBITS;
	     if (z2!=DIST) q=(DIST-z2);
	     else q=1;
	     qq=q>>1;
	     x2 = (DIST*((int)(feld->IS11*feld->xr[i]+feld->IS21*feld->yr[i]+feld->IS31*feld->zr[i])>>FPBITS)+qq)/q;
	     y2 = (DIST*((int)(feld->IS12*feld->xr[i]+feld->IS22*feld->yr[i]+feld->IS32*feld->zr[i])>>FPBITS)+qq)/q;
	     feld->xbuf[feld->page][i]=((x2+128)/256)+SCRX/2;
	     feld->ybuf[feld->page][i]=SCRY/2-((y2+128)/256)+feld->offset;
	     xl=feld->xbuf[feld->page][i];
	     yl=feld->ybuf[feld->page][i];
	     if (xl >=0 && xl <SCRX && yl >=feld->offset && yl < (SCRY+feld->offset) && z2<=DIST && z2>=-DIST)
	       {
		  vga_setcolor(cbase+(z2*16)/DIST);
		  vga_drawpixel(xl,yl);
	       }
	  }
     }

void update(struct mfield *feld)
{
    plotdots(feld);
    if(vga_getkey()!=0 && vga_getkey()!=-1) authenticate();
}

void sequence(int mseq,int stime, int rs, int rt, int ru,struct mfield *feld)
{
    int j; 
    feld->mtable=mseq;
    for (j=0;j<stime;j++)
    {
	update(feld);
	feld->s+=rs;
	feld->t+=rt;
	feld->u+=ru;
    }
}

void restore(int what, struct mfield *feld)
{
    int j;
    for(j=0;j<feld->numstars;j++)
    {
	feld->xr[j]=feld->xo[what][j];
	feld->yr[j]=feld->yo[what][j];
	feld->zr[j]=feld->zo[what][j];
    }
}



morphdots(int argc, char **argv)
{
    struct mfield this;
    int i;
         
    if(argc ==3)
    {
	this.numstars=atoi(argv[2]);
	if(this.numstars<1 || this.numstars>MAXNUMSTARS)
	{
	    printf("Number of dots must be between 1 and %d.\n",MAXNUMSTARS);exit(-1);
	}
    }
    else
    {
	this.numstars=600;
    }                          
    this.page=1;
    this.offset=0;
    vga_setmode(G320x240x256);
    signals();
    minitpalette();
    mmksintab(&this);
    minitfield(&this);

    sequence(ATOM2PLAIN,MTIME,0,4,5,&this);
    while(1)
    {
	sequence(NOP,300,0,4,5,&this);
	sequence(PLAIN2SPHERE,MTIME,0,4,5,&this);
	sequence(NOP,300,0,4,5,&this);
	sequence(SPHERE2TORUS,MTIME,0,4,5,&this);
	restore(TORUS,&this);
	sequence(NOP,400,0,4,5,&this);
	sequence(TORUS2SPHERE,MTIME,0,4,5,&this);
	restore(SPHERE,&this);
	sequence(NOP,100,0,4,3,&this);
	sequence(SPHERE2FOURBALL,MTIME,0,4,5,&this);
	sequence(NOP,400,0,4,5,&this);
	sequence(FOURBALL2FOURTORUS,MTIME,0,4,5,&this);
	restore(FOURTORUS,&this);
	sequence(NOP,50,0,4,5,&this);
	sequence(NOP,60,-1,4,6,&this);
	sequence(NOP,70,-2,4,7,&this);
	sequence(NOP,80,-3,4,8,&this);
	sequence(NOP,90,-4,4,9,&this);
	sequence(NOP,80,-3,4,8,&this);
	sequence(NOP,70,-2,4,7,&this);
	sequence(NOP,60,-1,4,6,&this);
	sequence(FOURTORUS2FOURBALL,MTIME,0,4,5,&this);
	sequence(NOP,200,0,4,5,&this);
	sequence(FOURBALL2PLAIN,MTIME,0,4,5,&this);
	sequence(PLAIN2SPHERE,MTIME,0,4,3,&this);
	restore(SPHERE,&this);
	sequence(NOP,300,0,4,3,&this);
	sequence(SPHERE2KEGEL,MTIME,0,4,3,&this);
	sequence(NOP,300,0,4,3,&this);
	sequence(KEGEL2TORBALLS,MTIME,0,4,5,&this);
	sequence(NOP,200,0,4,5,&this);
	sequence(TORBALLS2RANDOM,MTIME,0,4,5,&this);
	restore(RANDOM,&this);
	sequence(RANDOM2PLAIN,MTIME,0,4,5,&this);
    }
}


/* Object creation routines */


/* creating a plain in object nr, starting at point start using length 
   points, having length xlong and width zlong and no height */

void create_plain(int nr, int start, int length, int xlong, int  zlong,struct mfield *feld) { 
    int i;
    for (i=start;i<(start+length);i++) 
    {
	feld->xo[nr][i]=-xlong+((2*xlong)/(int)sqrt(length))*((i-start)%(int)sqrt(length));
	feld->yo[nr][i]= 0;
	feld->zo[nr][i]=-zlong+(2*zlong)/(int)sqrt(length)*((i-start)/(int)sqrt(length));
    }
} 
/* end create_plain */	


/* create a random field in object nr */

void create_random(int nr, int start, int length, struct mfield *feld) { 
    int i;
    
    for (i=start;i<length;i++)
    {
	feld->xo[nr] [i]=SIZE-random()%(SIZE<<1);
	feld->yo[nr] [i]=SIZE-random()%(SIZE<<1);
	feld->zo[nr] [i]=random()%SIZE-SIZE/2;
    }
} 
/* end create_random */


/* atomize field */

void create_atom(int nr, int start, int length, struct mfield *feld) {
    int i;
    for (i=start;i<length;i++)
    {
	feld->xo[nr][i]=0;
	feld->yo[nr][i]=0;
	feld->zo[nr][i]=0;
    }
}
/* end create_atom */

/* simple sphere */

void create_sphere( int nr, int start, int length, int radius, struct mfield *feld) {

    int i,j,n,k;
    float w,w1,w2;
    
    n=(int) sqrt(length);
    
    w=2*M_PI/n;
    k=start;
    
    for (j=0;j<n;j++)
    {
	w1=j*w;
	w2=0;
	for (i=0;i<n;i++)
	{
	    feld->yo[nr] [k]=cos(w2)*radius;
	    feld->zo[nr] [k]=cos(w1)*radius*sin(w2);
	    feld->xo[nr] [k]=sin(w1)*radius*sin(w2);
	    k++;
	    w2+=(w/2.0);
	}
    }
    
    for (;k<(start+length);k++) 
    {
	feld->yo[nr][k]=-radius;
	feld->xo[nr][k]=0;
	feld->zo[nr][k]=0; 
    }
}
/* Sphere end */

/* create a torus with inner radius rb and ring-radius ra */
 
void create_torus(int nr, int start, int length, int ra, int rb, struct mfield *feld) { 

    int i,j,n,k,r;
    float w,w1,w2;
    
    n=(int) (sqrt(length/2));
    w=M_PI/n;
    k=start;

    for (j=0;j<2*n;j++)
    {
	w1=j*w;
	w2=0;
	for (i=0;i<n;i++)
	{
	    feld->yo[nr][k]=cos(w2)*rb;
	    r=(ra)+rb*sin(w2);
	    
	    feld->zo[nr][k]=cos(w1)*r;
	    feld->xo[nr][k]=sin(w1)*r;
	    
	    k++;
	    w2+=(w*2);
	}
    }
    for (j=k-1;k<start+length;k++) { 
	feld->yo[nr][k]=feld->yo[nr][j];
	feld->xo[nr][k]=feld->xo[nr][j];
	feld->zo[nr][k]=feld->zo[nr][j]; 
    }
}
/* Torus end */


/* Kegel begin */

void create_kegel(int nr, int start, int length, int radius, int hi, struct mfield *feld) 
{
    int i, j,n,k,r;
    float w,w1,w2;
    
    n=(int)(sqrt(length));
    
    w=M_PI*2/n;
    k=start;
    for (j=0;j<n;j++)
    {
	r=j*radius/n;
	w2=0;
	for (i=0;i<n;i++)
	{
	    feld->xo[nr] [k]=(int)(r*sin(w2));
	    feld->zo[nr] [k]=(int)(r*cos(w2));
	    feld->yo[nr] [k]=((k-start)*hi)/length;
	    w2+=w;
	    k++;
	}
    }
    for (;k<length+start;k++) { feld->yo[nr][k]=0;feld->xo[nr][k]=0;feld->zo[nr][k]=0; }
    }
/*Kegel end */

/* Move an object */

void move_object(int nr, int start, int length, int xa, int ya, int za, struct mfield *feld) 
	
{
    int i;
    for (i=start;i<start+length;i++) {
	feld->xo[nr][i]+=xa;
	feld->yo[nr][i]+=ya;
	feld->zo[nr][i]+=za;
    }
}
/* end move */
