
/*----------------------------------------------------------------------------*

	LinuxInfo_m68k.c
		by Alex Buell
			September 1998

 ----------------------------------------------------------------------------- 

	Handles the m68k architecture	

 ----------------------------------------------------------------------------- 

	HISTORY

	1.01 - Initial development

 -----------------------------------------------------------------------------*/

#include "linuxinfo.h"

#ifdef system_m68k

void GetHardwareInfo(struct hw_stat *hw)
{
	int processors = 0; 
	float bogomips = 0.0;
	float tempbogo;
	LONGLONG memory = 0;

	char temp_string[BUFSIZ], temp_string2[BUFSIZ];
	char chip[BUFSIZ] = "Unknown";

	FILE *procfile;
	struct stat st_buf;

	if ((procfile = fopen(CPUINFO_FILE, "r")) != NULL) 
	{
		while (fscanf(procfile, "%s", (char *)&temp_string2) != EOF) 
		{
			if (processors == 0)
			{ 
				if (!(strcmp(temp_string2, "CPU:")))
					fscanf(procfile, "%s", (char *)&chip);
			}
	
			if (!(strcmp(temp_string2, "BogoMips:")))
			{
				processors++;
				fscanf(procfile, "%s%f", (char *)&hw->hw_bogomips, &tempbogo);
				bogomips += tempbogo;
			}
		}
		fclose(procfile);
	}

	stat(MEMORY_FILE, &st_buf);
	memory = st_buf.st_size;
	memory /= 1024; memory /= 1024;
	sprintf(hw->hw_memory, "%ld", (long int)memory);

	hw->hw_processors = processors;

	sprintf(hw->hw_cpuinfo, "%s", chip);
	sprintf(hw->hw_bogomips, "%0.2f", bogomips);
}
#endif /* system_m68k */
