/* lib/sys -- irqtune support library (sys control) */

#pragma member irqtune.h

/* sysexit -- do cleanup and exit */
void
sysexit(int code)
{

	if (code)
		zprtx("irqtune: errors occurred%s\n",
			(mstopt & OPTERR) ? "" : " (rerun with -e for full error text)");
	else
		zprtx("irqtune: complete\n");

	exit(code);
}

/* sysfault -- output howfar to stxerr */
/* RETURNS: length of output string */
int
sysfault(const char *fmt,...)
/* fmt -- format */
{
	va_list ap;
	int len;

	va_start(ap,fmt);
	len = zprtvx(0,fmt,ap);
	va_end(ap);

	sysexit(0);

	return len;
}
