<!-- ...................................................................... -->
<!-- XHTML 1.1 Structure Module  .......................................... -->
<!-- file: xhtml11-struct-1.mod

     This is XHTML 1.1, a modular variant of XHTML 1.0.
     Copyright 1998-1999 W3C (MIT, INRIA, Keio), All Rights Reserved.
     Revision: @(#)xhtml11-struct-1.mod 1.6 99/08/26 SMI

     This DTD module is identified by the PUBLIC and SYSTEM identifiers:

     PUBLIC "-//W3C//ELEMENTS XHTML 1.1 Document Structure 1.0//EN"
     SYSTEM "xhtml11-struct-1.mod"

     Revisions:
     (none)
     ....................................................................... -->

<!-- Document Structure

        title, head, body, html

     The Structure Module defines the major structural elements
     and their attributes.

     Note that the content model of the head element type is 
     redeclared when the Base Module is included in the DTD.
-->

<!-- title: Document Title ............................. -->

<!-- The title element is not considered part of the flow of text.
     It should be displayed, for example as the page header or
     window title. Exactly one title is required per document.
-->

<!ENTITY % Title.element  "INCLUDE" >
<![%Title.element;[
<!ENTITY % Title.content  "( #PCDATA )" >
<!ELEMENT title  %Title.content; >
<!-- end of Title.element -->]]>

<!ENTITY % Title.attlist  "INCLUDE" >
<![%Title.attlist;[
<!ATTLIST title
      %I18n.attrib;
>
<!-- end of Title.attlist -->]]>

<!-- head: Document Head ............................... -->

<!ENTITY % Head.element  "INCLUDE" >
<![%Head.element;[
<!ENTITY % Head.content
    "( %Head-opts.mix;, title, %Head-opts.mix; )"
>
<!ELEMENT head  %Head.content; >
<!-- end of Head.element -->]]>

<!ENTITY % Head.attlist  "INCLUDE" >
<![%Head.attlist;[
<!-- reserved for future use with document profiles -->
<!ENTITY % Profile.attrib
     "profile      %URI.datatype;           '%XHTML.profile;'"
>

<!ATTLIST head
      %I18n.attrib;
      %Profile.attrib;
>
<!-- end of Head.attlist -->]]>

<!-- body: Document Body ............................... -->

<!ENTITY % Body.element  "INCLUDE" >
<![%Body.element;[
<!ENTITY % Body.content
     "( %Block.mix; )+"
>
<!ELEMENT body  %Body.content; >
<!-- end of Body.element -->]]>

<!ENTITY % Body.attlist  "INCLUDE" >
<![%Body.attlist;[
<!ATTLIST body
      %Common.attrib;
>
<!-- end of Body.attlist -->]]>

<!-- html: XHTML Document Element ...................... -->

<!ENTITY % Html.element  "INCLUDE" >
<![%Html.element;[
<!ENTITY % Html.content  "( head, body )" >
<!ELEMENT html  %Html.content; >
<!-- end of Html.element -->]]>

<!ENTITY % Html.attlist  "INCLUDE" >
<![%Html.attlist;[
<!-- namespace attribute value defined in driver
-->
<!ENTITY % Xmlns.attrib
     "xmlns        %URI.datatype;           #FIXED '%XHTML.ns;'"
>

<!ATTLIST html
      %I18n.attrib;
      %Xmlns.attrib;
>
<!-- end of Html.attlist -->]]>

<!-- end of xhtml11-struct-1.mod -->
