/**************************************************************************** 
** File: spx.c
**
** Author: Mike Borella
**
** Comments: Dump SPX header information
**
** $Log: spx.c,v $
** Revision 1.2  1998/06/12 21:01:14  mborella
** Added log tag
**
*****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <netinet/in.h>
#include "config.h"
#include "spx.h"

extern struct arg_t *my_args;

/*----------------------------------------------------------------------------
**
** dump_spx()
**
** Parse SPX header and dump fields
**
**----------------------------------------------------------------------------
*/

void dump_spx(u_char *bp, int length)
{
  SPXhdr *spx;
 
  /*
   * Check length
   */

  if (length < sizeof(SPXhdr))
    {
      printf("Truncated header, length = %d bytes\n", length);
      return;
    }

  /*
   * Dump header announcement
   */

  printf("-----------------------------------------------------------------\n");
  printf("                        SPX Header\n");
  printf("-----------------------------------------------------------------\n");

  /*
   * View the packet as an SPX header
   */

  spx = (SPXhdr *) bp;

  /*
   * Dump header fields
   */
  
  if (!my_args->t)
    {
      printf("Connection control: %d\n", spx->cc);
      printf("Data stream type:   %d\n", spx->ds_type);
      printf("Source conn ID:     %d\n", ntohs(spx->s_id));
      printf("Dest conn ID:       %d\n", ntohs(spx->d_id));
      printf("Sequence number:    %d\n", ntohs(spx->seqno));
      printf("Ack number:         %d\n", ntohs(spx->ackno));
      printf("Allocation number:  %d\n", ntohs(spx->allocno));
    }


}
