#!/bin/csh
#		GMT EXAMPLE 09
#
#		@(#)job09.csh	1.8  06/07/99
#
# Purpose:	Make wiggle plot along track from geoid deflections
# GMT progs:	pswiggle, pstext, psxy
# Unix progs:	$AWK, ls, paste, tail, rm
#
pswiggle track_*.xys -R185/250/-68/-42 -U"Example 9 in Cookbook" -K -Jm0.13i -Ba10f5 -G0 -Z2000 \
   -W0.25p -S240/-67/500/@~m@~rad >! example_09.ps
psxy -R -Jm -O -K ridge.xy -W1.25p >> example_09.ps
psxy -R -Jm -O -K -M fz.xy -W0.5pta >> example_09.ps
if (-e tmp) then
	\rm -f tmp
endif
foreach file (track_*.xys)	# Make label file
	tail -1 $file >>! tmp
end
ls track_*.xys | $AWK -F. '{print $2}' >! tracks.lis
paste tmp tracks.lis | $AWK '{print $1, $2, 10, 50, 1, 7, $4}' | pstext -R -Jm -D-0.05i/-0.05i -O \
   >> example_09.ps
\rm -f tmp tracks.lis .gmtcommands
