#!/bin/bash
#		GMT EXAMPLE 04
#
#		@(#)job4c.bash	1.4  12/10/98
#
# 3-D perspective color plot of Hawaiian topography and geoid
# GMT progs:	grdcontour, grdview, pscoast, pstext, psxyz
# Unix progs:	echo, rm
#
grdgradient geoid.grd -A0 -Gg_intens.grd -Nt0.75 -M
grdgradient topo.grd -A0 -Gt_intens.grd -Nt0.75 -M
#
grdview geoid.grd -Ig_intens.grd -JM6.75i -E60/30 -R195/210/18/25 -Cgeoid.cpt -Qi100 -K -X1.5i -Y1.25i -P -U/-1.25i/-1i/"Example 4c in Cookbook" > example_4c.ps
pscoast -JM -E60/30 -R -B2/2NEsw -G0 -O -K >> example_4c.ps
echo '205 26 0 0 1.1' | psxyz -JM -E60/30 -R -SV0.2i/0.5i/0.4ii -W1p -G255/0/0 -O -K -N >> example_4c.ps
echo '205 29.2 36 -90 1 5 N' | pstext -JM -E60/30 -R -O -K -N >> example_4c.ps
grdview topo.grd -It_intens.grd -JM -JZ3.4i -Ctopo.cpt -E60/30 -R195/210/18/25/-6/4 -N-6/200/200/200 -Qi100 -O -K -Y2.2i >> example_4c.ps
psbasemap -JM -JZ3.4i -E60/30 -R -Z-6 -O -K -B2/2/2:"Topo (km)":neZ >> example_4c.ps
echo '3.25 5.75 60 0.0 33 2 H@#awaiian@# R@#idge' | pstext -R0/10/0/10 -Jx1i -O >> example_4c.ps
\rm -f *_intens.grd .gmtcommands
