function set_view (alt, az)
#
# set_view ([alt, az])
#
# Set up the altitude and azimute in degrees for posterior 3d plots.
#
# If called without arguments, rotates iteratively a cube.
# The keys `jklmi' control the rotation, in the usual star-like maker.
# The key `k' sets a default view. Finish with the enter key.
# Each key press steps the value by 10 degrees.
# If the Shift key is also pressed the step is by 1 degree value.
#
#     i
#   j k l
#     m

global	__pl __pl_inited 

if (!exist("__pl_inited") || plglevel == 0)
	figure(0)
endif

__pl_strm = plgstrm + 1;

if (nargin == 2)
	__pl.az(__pl_strm) = az;
	__pl.alt(__pl_strm) = alt;
	return
endif

x = y = [0;1];
z = ones(2);
xm = ym = zm = 0;
xM = yM = zM = 1;

plcol(15);

__pl_plenv(-1.5, 1.5, -1.5, 2.5, 0, -2);
plw3d(2, 2, 2, xm, xM, ym, yM, zm, zM, __pl.alt(__pl_strm), __pl.az(__pl_strm))

plmtex("t", 3, 0.5, 0.5, sprintf("Alt=%d   Az=%d", __pl.alt(__pl_strm), __pl.az(__pl_strm)));
plbox3("bnstu", "X axis", 0.0, 0,"bnstu", "Y axis", 0.0, 0,"bdcmnstuv", "Z axis", 0.0, 0)

plot3d(x,y,z,3,1);
plflush
		
while ((c = toascii(kbhit)) != 10)
	switch (c)
	case (107)	# home
		__pl.az(__pl_strm) = -60; __pl.alt(__pl_strm) = 30;
	case (106) 	# left j
		__pl.az(__pl_strm) = __pl.az(__pl_strm) - 10;
	case (108)	# rigth l
		__pl.az(__pl_strm) = __pl.az(__pl_strm) + 10;	
	case (105)	# up i
		__pl.alt(__pl_strm) = __pl.alt(__pl_strm) + 10;
	case (109)	# down m
		__pl.alt(__pl_strm) = __pl.alt(__pl_strm) - 10;
	case (106-32) 	# left S-j
		__pl.az(__pl_strm) = __pl.az(__pl_strm) - 1;
	case (108-32)	# rigth S-l
		__pl.az(__pl_strm) = __pl.az(__pl_strm) + 1;	
	case (105-32)	# up S-i
		__pl.alt(__pl_strm) = __pl.alt(__pl_strm) + 1;
	case (109-32)	# down S-m
		__pl.alt(__pl_strm) = __pl.alt(__pl_strm) - 1;		
	endswitch

	if (__pl.alt(__pl_strm) > 90)
		__pl.alt(__pl_strm) = 90;
	elseif (__pl.alt(__pl_strm) < 0)
		__pl.alt(__pl_strm) = 0;
	endif

	__pl_plenv(-1.5, 1.5, -1.5, 2.5, 0, -2);
	plw3d(2, 2, 2, xm, xM, ym, yM, zm, zM, __pl.alt(__pl_strm), __pl.az(__pl_strm))
	plbox3("bnstu", "x axis", 0.0, 0,"bnstu", "y axis", 0.0, 0,"bdcmnstuv", "z axis", 0.0, 0)
	plmtex("t", 3, 0.5, 0.5, sprintf("Alt=%d   Az=%d", __pl.alt(__pl_strm), __pl.az(__pl_strm)));
	plot3d(x,y,z,3,1);
	plflush

endwhile
		
endfunction
