function cmap = hot(m)

#	hot(m) returns an m-by-3 matrix containing a "hot" colormap.
#	without arguments, cmap has lenght 32

if (nargin < 1)
	m = 32;
endif

n = fix(3/8*m);
r = [(1:n)'/n; ones(m-n,1)];
g = [zeros(n,1); (1:n)'/n; ones(m-2*n,1)];
b = [zeros(2*n,1); (1:m-2*n)'/(m-2*n)];

cmap = [r g b];

endfunction
