/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * win_register.c
 */

#include <stdlib.h>

#include <tcl.h>
#include <string.h>
#include <constants.h>
#include <math.h>

#include <view.h>
#include <tcl_dstool.h>

/* local declarations */
static int twod_register(int n, int argc, char *argv[]);
static int oned_register(int n, int argc, char *argv[]);
static int geomview_register(int n, int argc, char *argv[]);


struct Key win_key[] = {
  {"TWOD", TWOD},
  {"ONED", ONED},
  {"GEOMVIEW" , GEOMVIEW},
  {"RANGE", RANGE},
  {"DISMISS", DISMISS},
  {"ACTIVATE", ACTIVATE},
  {"CONFIG", CONFIG},
  {"Varb", VARB},
  {"Param", PARAM},
  {"Funct", FUNCT},
  {"COLORMODE", COLORMODE},
};

int N_WINKEY = sizeof(win_key)/sizeof(struct Key);

int
win_keyword(char *word)
{
  int i;
  for (i=0; i<N_WINKEY; i++)
    if (!strcmp(word,win_key[i].word))
      return(win_key[i].index);
  return(NO_KEY);
}

char *
win_keyindex(int i)
{
  int j;
  for (j=0; j<N_WINKEY; j++)
    if (win_key[j].index == i) return(win_key[j].word);
  return(NULL);
}

int 
winCmd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  int n, kw, i, ok=TRUE;

  /* debugging output */
/*  for (i=0; i<argc; i++) 
    {
      fprintf(stdout, "%s ",argv[i]);
    }
  fprintf(stdout,"\n");
 */

  if (argc <3) ok = FALSE;

  else
    {
      kw = win_keyword(argv[1]);
      switch(kw)
	{
	case TWOD:
	  n = atoi(argv[2]);
	  ok = twod_register(n,argc-3,argv+3);
	  break;
	case ONED:
	  n = atoi(argv[2]);
	  ok = oned_register(n,argc-3,argv+3);
	  break;
	case GEOMVIEW:
	  n = atoi(argv[2]);
	  ok = geomview_register(n,argc-3, argv+3);
	  break;
	default:
	  fprintf(stdout,"View device not recognized.\n");
	  ok = FALSE;
	}
    }

  if (!ok) 
    {
      for (i=0; i<argc; i++) 
	{
	  fprintf(stdout, "%s ",argv[i]);
	}
      fprintf(stdout, "\n");
      fprintf(stdout," usage: window_register TWOD 1 ...\n");
    }

  return TCL_OK;
}


static int
twod_register(int n, int argc, char *argv[])
{
  int kw, ok=TRUE;
  int ht,vt,hi,vi,width,height;
  double hmin,hmax,vmin,vmax;
  int cmode;

  if ((argc--)<1) return(FALSE);
  kw = win_keyword(*(argv++));
  switch (kw)
    {
    case ACTIVATE:
      twod_activate(n);
      break;
    case CONFIG:
      if (argc<2) return(FALSE);
      width = atoi(*(argv++));
      height = atoi(*(argv++));
      twod_config(n,width,height);
      break;
    case RANGE:
      if (argc<8) return(FALSE);
      ht = win_keyword(*(argv++));
      hi = atoi(*(argv++));
      hmin = atof(*(argv++));
      hmax = atof(*(argv++));
      vt = win_keyword(*(argv++));
      vi = atoi(*(argv++));
      vmin = atof(*(argv++));
      vmax = atof(*(argv++));
      twod_range(n,ht,hi,hmin,hmax,vt,vi,vmin,vmax);
      break;
    case DISMISS:
      twod_dismiss(n);
      break;
    case COLORMODE:
      cmode = atoi(*(argv++));
      twod_colormode( n, cmode );
      break;
    default:
      fprintf(stdout,"TWOD command %s not recognized.\n", *(argv-1));
      ok = FALSE;
    }
  return ok;
}

static int
oned_register(int n, int argc, char *argv[])
{
  int kw, iterate, width, height, ok=TRUE;
  double hmin, hmax, vmin, vmax;

  if ((argc--)<1) return(FALSE);
  kw = win_keyword(*(argv++));
  switch (kw)
    {
    case ACTIVATE:
      oned_activate(n);
      break;
    case CONFIG:
      if (argc<2) return(FALSE);
      width = atoi(*(argv++));
      height = atoi(*(argv++));
      oned_config(n,width,height);
      break;
    case RANGE:
      if (argc<5) return(FALSE);
      hmin = atof(*(argv++));
      hmax = atof(*(argv++));
      vmin = atof(*(argv++));
      vmax = atof(*(argv++));
      iterate = atoi(*(argv++));
      oned_range(n, hmin, hmax, vmin, vmax, iterate);
      break;
    case DISMISS:
      oned_dismiss(n);
      break;
    default:
      ok = FALSE;
    }
  return ok;
}

static int
geomview_register(int n, int argc, char *argv[])
{
  int kw, ok=TRUE;

  if ((argc--)<1) return(FALSE);
  kw = win_keyword(*(argv++));
  switch (kw)
    {
    case ACTIVATE:
      gv_activate(n);
      break;
    case CONFIG:
      /* gv_config(n); */
      break;
    case DISMISS:
      gv_dismiss(n);
      break;
    default:
      fprintf(stdout,"GEOMVIEW command %s not recognized.\n", *(argv-1));
      ok = FALSE;
    }
  return ok;
}

