/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * point_plot.c
 */

#include <stdio.h>
#include <math.h>

#include <view.h>
#include <plot.h>
#include "dscolor.h"

static int geomview_point_plot(int n, double *x, double *p, int color, int symbol);
static int twod_point_plot(int n, TWOD_VIEW_ITEM *twod, double *xx, double *p,
			   int color, int symbol);

int
point_plot(double *x, double *p, int color, int symbol)
{
  VIEW_ITEM *v = Views;

  while (v) 
    {
      switch (v->type)
	{
	case GEOMVIEW:
	  geomview_point_plot(v->number, x, p, color, symbol);
	  break;
	case TWOD:
	  twod_point_plot(v->number, &(v->data.twod), x, p, color, symbol);
	  break;
	case ONED:
	  break;
	default:
	  fprintf(stdout,"Unrecognized view device in point_plot.\n");
	}
      v = v->next_View;
    }
  return 0;
}


static int
geomview_point_plot(int n, double *x, double *p, int color, int symbol)
{
  if (n != 1)
    {
      fprintf(stdout,"Only one GEOMVIEW window currently implemented.\n");
      return 0;
    }

  return 0;
}

static int
twod_point_plot(int n, TWOD_VIEW_ITEM *twod, double *xx, double *p,
		    int color, int symbol)
{
  int x, y;
  double dx, dy;
  int icolor;

  /* will need function values */
  if ( (twod->hortype == FUNCT) || (twod->vertype == FUNCT) )
      view_auxf(view_f, xx, p);

  switch(twod->hortype)
    {
    case VARB:
      dx = xx[twod->horindex];
      break;
    case PARAM:
      dx = p[twod->horindex];
      break;
    case FUNCT:
      dx = view_f[twod->horindex];
      break;
    default:
      fprintf(stdout,"twod_point_plot: error in hor type\n");
    }
  switch(twod->vertype)
    {
    case VARB:
      dy = xx[twod->verindex];
      break;
    case PARAM:
      dy = p[twod->verindex];
      break;
    case FUNCT:
      dy = view_f[twod->verindex];
      break;
    default:
      fprintf(stdout,"twod_plot: error in ver type\n");
	}
  dx = (dx - twod->hormin) / (twod->hormax - twod->hormin);
  dy = (twod->vermax - dy) / (twod->vermax - twod->vermin);
  if ((dx >= 0.0) && (dx < 1.0) && (dy > 0.0) && (dy <= 1.0))
    {
      x = (int) floor(dx*twod->width);
      y = (int) floor(dy*twod->height);

      icolor = DsColor_get_index( 1, 0, color );
      twod_point(n,x,y,icolor,symbol);
    }
  
  return 0;
}
