/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * iter_forw.c
 */

#include "manifold.h"
#include "iterate.h"

/*
  iter_forw() calculates the kth image of x under the function f, ie, y = f^k (x).  
  If (part of) the phase space is periodic, then y is projected onto the relevant tori.
		(*f)();		  the function to iterate
		k;		  compute this many iterates of f; 
				  ie, return f^k(x)
		*y,*x,*p;	  vectors for f^k(x), x, and parameters.
		ph_sp_dim;	  dimension of phase space including time
		time_step;	  +1.0 if we are iterating a forward map; 
                                  -1.0 for an inverse map
		*v;		  workspace of length ph_sp_dim
                *manifold;
*/
int
iter_forw( int (*f)(double*, double*, double*),
	   int k, double *y, double *x, double *p,
	   int ph_sp_dim, double time_step, double *v,
	   Manifold *manifold)
{
  int		i;
  int		v_dim = ph_sp_dim - 1;

  if ( k == 1 )					  /* quick and easy */
    {
      f(y,x,p);  y[v_dim] = x[v_dim] + time_step; /* iterate and increment time */
      project( v_dim, y, manifold );
    }
  else						  /* utilize temp storage */
    {
      for ( i=0; i < ph_sp_dim; i++ )		  /* copy time too */
	v[i] = x[i];
      while (k--)
	{
	  f(y,v,p);   y[v_dim] = v[v_dim] + time_step; /* iterate and increment time */
	  project( v_dim, y, manifold );
	  for ( i=0; i < ph_sp_dim; i++ )	  /* copy time too */
	    v[i] = y[i];
	}
    }
}


