/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * flow_install.c
 */

/*
 * Create FLOW postmaster object
 */
#include <stdio.h>
#include <constants.h>
#include <defaults.h>
#include <pm.h>
#include <prop.h>

#include "flow.h"
#include "view.h"

static void flow_reset(void);

static char *FLOW_OBJ_NAME = "Flow";

static char *FLOW[] = {
  "Flow.Stepsize", "Flow.Start_Save_Points",
  "Flow.Total_Iterates", "Flow.Skip_Size",
  "Flow.Direction",
  "Flow.Stopping_Condition", 
  "Flow.Varb_Events", "Flow.Funct_Events",
  "Flow.Varb_Event_Values", "Flow.Funct_Event_Values",
  "Flow.Final_Time",
  "Flow.Forwards", "Flow.Backwards", "Flow.Continue",
  "Flow.Clear_Last", "Flow.Clear_All",
  "Flow.Plot_Function",
  "Flow.Reset", "Flow.Bump_Color", "Flow.Unbump_Color", "Flow.Reset_Color",
  "Flow.Alt_Color"
  };

typedef enum {
  STEPSZ=0, STARTSAVE_POINTS, TOT_ITERATES,
  SKIPSZ, DIRECTION, STOPPING_CONDITION,
  VARB_EVENTS, FUNCT_EVENTS,
  VARB_EVENT_VALUES, FUNCT_EVENT_VALUES,
  FINAL_TIME,
  GO_FORWARDS, GO_BACKWARDS, GO_CONTINUE,
  CLEAR_LAST, CLEAR_ALL,
  PLOT_FUNCTION,
  RESET, BUMP_COLOR, UNBUMP_COLOR, RESET_COLOR, ALT_COLOR
  } FLOW_t;


void
  flow_install()
{

  pm(CREATE_OBJ, FLOW_OBJ_NAME,
     CREATE_ELEM, FLOW[STEPSZ], DBL,
     CREATE_ELEM, FLOW[STARTSAVE_POINTS], INT,
     CREATE_ELEM, FLOW[TOT_ITERATES], INT,
     CREATE_ELEM, FLOW[SKIPSZ], INT,
     CREATE_ELEM, FLOW[DIRECTION], INT,
     CREATE_ELEM, FLOW[STOPPING_CONDITION], INT,
     CREATE_ELEM, FLOW[VARB_EVENTS], INT_LIST,
     CREATE_ELEM, FLOW[FUNCT_EVENTS], INT_LIST,
     CREATE_ELEM, FLOW[VARB_EVENT_VALUES], DBL_LIST,
     CREATE_ELEM, FLOW[FUNCT_EVENT_VALUES], DBL_LIST,
     CREATE_ELEM, FLOW[FINAL_TIME], DBL,
     CREATE_ELEM, FLOW[GO_FORWARDS], FNCT,
     CREATE_ELEM, FLOW[GO_BACKWARDS], FNCT,
     CREATE_ELEM, FLOW[GO_CONTINUE], FNCT,
     CREATE_ELEM, FLOW[CLEAR_LAST], FNCT,
     CREATE_ELEM, FLOW[CLEAR_ALL], FNCT,
     CREATE_ELEM, FLOW[PLOT_FUNCTION], ADDRS,
     CREATE_ELEM, FLOW[RESET], FNCT,
     CREATE_ELEM, FLOW[BUMP_COLOR], FNCT,
     CREATE_ELEM, FLOW[UNBUMP_COLOR], FNCT,
     CREATE_ELEM, FLOW[RESET_COLOR], FNCT,
     CREATE_ELEM, FLOW[ALT_COLOR], INT,
     NULL);

  pm(CREATE_ELEM, "Memory.Traj", MEMRY, NULL);

  pm(INIT, FLOW[GO_FORWARDS],
     INIT, FLOW[GO_BACKWARDS],
     INIT, FLOW[GO_CONTINUE],
     INIT, FLOW[CLEAR_LAST],
     INIT, FLOW[CLEAR_ALL],
     PUT, FLOW[GO_FORWARDS], flow_forwards,
     PUT, FLOW[GO_BACKWARDS], flow_backwards,
     PUT, FLOW[GO_CONTINUE], flow_continue,
     PUT, FLOW[CLEAR_LAST], clear_last_trajectory,
     PUT, FLOW[CLEAR_ALL], clear_all_trajs,
     INIT, FLOW[PLOT_FUNCTION],
     PUT, FLOW[PLOT_FUNCTION], traj_plot,
     INIT, FLOW[RESET],
     PUT, FLOW[RESET], flow_reset,
     INIT, FLOW[BUMP_COLOR],
     PUT, FLOW[BUMP_COLOR], bump_color,
     INIT, FLOW[UNBUMP_COLOR],
     PUT, FLOW[UNBUMP_COLOR], unbump_color,
     INIT, FLOW[RESET_COLOR],
     PUT, FLOW[RESET_COLOR], reset_color,
     NULL);

}


static void
flow_reset()
{
  int n_varb, n_funct;

  n_varb = *((int *) pm(GET, "Model.Varb_Dim", NULL));
  n_funct = *((int *) pm(GET, "Model.Funct_Dim", NULL));

  pm(INIT, "Memory.Traj", TRAJ_MEMORY,
     INIT, "Flow.Varb_Events", n_varb, 
     INIT, "Flow.Funct_Events", n_funct, 
     INIT, "Flow.Varb_Event_Values", n_varb,
     INIT, "Flow.Funct_Event_Values", n_funct,
     NULL);

  pm(PUT, FLOW[TOT_ITERATES], TOTAL_ITERATES,
     PUT, FLOW[STARTSAVE_POINTS], START_SAVE_POINTS,
     PUT, FLOW[SKIPSZ], SKIP_SIZE,
     PUT, FLOW[STEPSZ], STEPSIZE,
     PUT, FLOW[DIRECTION], FORWARD,
     PUT, FLOW[STOPPING_CONDITION], PROP_NSTEP,
     PUT, FLOW[ALT_COLOR], -1,
     NULL);
}
