.\"
.\" %nmhwarning%
.\" $Id: burst.man,v 1.1.1.1 1999/04/30 18:08:36 doug Exp $
.\"
.\" include the -mh macro file
.so %etcdir%/tmac.h
.\"
.TH BURST %manext1% MH.6.8 [%nmhversion%]
.SH NAME
burst \- explode digests into messages
.SH SYNOPSIS
.in +.5i
.ti -.5i
burst
\%[+folder] \%[msgs]
\%[\-inplace] \%[\-noinplace]
\%[\-quiet]
.br
\%[\-noquiet]
\%[\-verbose] \%[\-noverbose]
\%[\-version]
\%[\-help]
.in -.5i
.SH DESCRIPTION
\fIBurst\fR considers the specified messages in the named folder to be
Internet digests, and explodes them in that folder.

If `\-inplace' is given, each digest is replaced by the \*(lqtable
of contents\*(rq for the digest (the original digest is removed).
\fIBurst\fR then renumbers all of the messages following the digest in the
folder to make room for each of the messages contained within the digest.
These messages are placed immediately after the digest.

If `\-noinplace' is given, each digest is preserved, no table of contents
is produced, and the messages contained within the digest are placed at
the end of the folder.  Other messages are not tampered with in any way.

The `\-quiet' switch directs \fIburst\fR to be silent about reporting
messages that are not in digest format.

The `\-verbose' switch directs \fIburst\fR to tell the user the general
actions that it is taking to explode the digest.

It turns out that \fIburst\fR works equally well on forwarded messages
and blind\-carbon\-copies as on Internet digests, provided that the
former two were generated by \fIforw\fR or \fIsend\fR.
.Fi
^$HOME/\&.mh\(ruprofile~^The user profile
.Pr
^Path:~^To determine the user's nmh directory
.Ps
^Current\-Folder:~^To find the default current folder
.Ps
^Msg\-Protect:~^To set mode when creating a new message
.Sa
\fIProposed Standard for Message Encapsulation\fR (RFC\-934),
.br
inc(1), msh(1), pack(1)
.De
`+folder' defaults to the current folder
.Ds
`msgs' defaults to cur
.Ds
`\-noinplace'
.Ds
`\-noquiet'
.Ds
`\-noverbose'
.Co
If a folder is given, it will become the current folder.  If `\-inplace'
is given, then the first message burst becomes the current message.
This leaves the context ready for a \fIshow\fR of the table of contents
of the digest, and a \fInext\fR to see the first message of the digest.
If `\-noinplace' is given, then the first message extracted from the
first digest burst becomes the current message.  This leaves the context
in a similar, but not identical, state to the context achieved when using
`\-inplace'.
.Bu
The \fIburst\fR program enforces a limit on the number of messages which
may be \fIburst\fR from a single message.  This number is on the order
of 1000 messages.  There is usually no limit on the number of messages
which may reside in the folder after the \fIburst\fRing.

Although \fIburst\fR uses a sophisticated algorithm to determine where
one encapsulated message ends and another begins, not all digestifying
programs use an encapsulation algorithm.  In degenerate cases, this
usually results in \fIburst\fR finding an encapsulation boundary
prematurely and splitting a single encapsulated message into two or
more messages.  These erroneous digestifying programs should be fixed.

Furthermore, any text which appears after the last encapsulated message
is not placed in a separate message by \fIburst\fR.  In the case of
digestified messages, this text is usually an \*(lqEnd of digest\*(rq
string.  As a result of this possibly un\-friendly behavior on the
part of \fIburst\fR, note that when the `\-inplace' option is used,
this trailing information is lost.  In practice, this is not a problem
since correspondents usually place remarks in text prior to the first
encapsulated message, and this information is not lost.
.En
