package com.jclark.xsl.expr;

import com.jclark.xsl.om.*;

class ExtensionFunctionCallExpr extends ConvertibleVariantExpr {
  private final Name name;
  private final VariantExpr[] args;

  ExtensionFunctionCallExpr(Name name, VariantExpr[] args) {
    this.name = name;
    this.args = args;
  }

  public Variant eval(Node node, ExprContext context) throws XSLException {
    Object[] argValues = new Object[args.length];
    for (int i = 0; i < args.length; i++)
      argValues[i] = args[i].eval(node, context).convertToObject();
    Object obj
      = context.getExtensionContext(name.getNamespace()).call(name.getLocalPart(),
							      node,
							      argValues);
    if (obj instanceof String)
      return new StringVariant((String)obj);
    if (obj instanceof Number)
      return new NumberVariant(((Number)obj).doubleValue());
    if (obj instanceof Boolean)
      return new BooleanVariant(((Boolean)obj).booleanValue());
    if (obj instanceof NodeIterator)
      return new NodeSetVariant((NodeIterator)obj);
    if (obj instanceof Node)
      return new NodeSetVariant(new SingleNodeIterator((Node)obj));
    if (obj instanceof Variant)
      return (Variant)obj;
    return new ObjectVariant(obj);
  }
}
