/*****************************************************************************
**
** parse_cl.c
**
** Mon May 31 20:27:52 1999
** mborella@stratos (Mike Borella)
**
** Main command line parsing routines
**
** Automatically created by genparse v0.3
**
** See http://www.borella.net/mike/Software/ for details
**
*****************************************************************************/


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include "parse_cl.h"

/*----------------------------------------------------------------------------
 *
 * usage()
 *
 *----------------------------------------------------------------------------
 */

void usage(char *executable)
{
  printf("usage: %s [ -o ] \n", executable);
  printf("  [ -h ] [ --help ] Print help screen \n");
  printf("  [ -o ] ");
  printf("[ --outfile ] ");
  printf("Output file for genparse C code");
  printf(" (default = parse_cl.c)");
  printf("\n");

  exit(1);
}

/*----------------------------------------------------------------------------
 *
 * free_args()
 *
 *----------------------------------------------------------------------------
 */

void free_args(struct arg_t *my_arg)
{
  if (my_arg->o != NULL) free(my_arg->o);
  free(my_arg);
}

/*----------------------------------------------------------------------------
 *
 * parse_cl()
 *
 *----------------------------------------------------------------------------
 */

struct arg_t *parse_cl(int argc, char *argv[])
{
  extern char *optarg;
  extern int optind;
  int option_index = 0;
  char c;
  struct arg_t *my_arg;
  int errflg = 0;

  static struct option long_options[] =
  {
    {"help", 0, 0, 'h'},
    {"outfile", 1, 0, 'o'},
    {0, 0, 0, 0}
  };


  my_arg = (struct arg_t *) malloc (sizeof(struct arg_t));

  my_arg->h = 0;
  my_arg->o = strdup("parse_cl.c");

  while ((c = getopt_long(argc, argv, "ho:", long_options, &option_index)) != EOF)
    {
      switch(c)
        {
        case 'h':
          my_arg->h ++;
          break;

        case 'o':
          my_arg->o = strdup(optarg);
          break;

        default:
          usage(argv[0]);

        }
    } /* while */

    if (errflg)
      usage(argv[0]);

    if (!(my_arg))
      usage(argv[0]);

  my_arg->optind = optind;
  return my_arg;
}
