# Standard rules for building modules
# CURDIR must be defined
proto:
	tlproto -m0+ -b$(CURDIR).h+$(CURDIR).pm $(PROTOUPDHEAD) \
		`find . -maxdepth 1 -name \*.cc -o -name \*.tlcc`

ifdef OLDGCC
$(CURDIR).so: $(OBJS)
	@echo Linuxconf can\'t handle a.out module, sorry
else
$(CURDIR).so: $(OBJS)
	$(GPPLINK) -g -shared -Wl,-soname,$(CURDIR).so.1 -o \
		$(SOPATH) \
		$(OBJS) $(EXTRAMODLIBS)
endif

std_local_clean:
	rm -f $(CURDIR).so.* `find . -name \*.bak`

# Check if we are in linuxconf source tree
# If not, we are using resources in linuxconf-devel package
ifeq "$(shell test -x $(LINUXCONF_PATH)/translate/msgcomp && echo ok)" "ok"
MSGCOMP=$(LINUXCONF_PATH)/translate/msgcomp
COPYDIR=../copydir.sh
RPMSPEC=../../builder/module.rpmspec
FILTERSPEC=../../builder/filterspec.sh
else
MSGCOMP=/usr/lib/linuxconf-devel/msgcomp
COPYDIR=/usr/lib/linuxconf-devel/copydir.sh
ifeq "$(shell test -f module.rpmspec && echo ok)" "ok"
RPMSPEC=module.rpmspec
else
RPMSPEC=/usr/lib/linuxconf-devel/module.rpmspec
endif
FILTERSPEC=/usr/lib/linuxconf-devel/filterspec.sh
endif


std_local_install:
	mkdir -p $(LIB_LINUXCONF)/modules
	mkdir -p $(LIB_LINUXCONF)/images
	mkdir -p $(LIB_LINUXCONF)/help.eng
	install -o root -g root -m 755 $(SOPATH) $(LIB_LINUXCONF)/modules
	$(MSGCOMP) -p./ -p$(LINUXCONF_HELP)/ \
		$(LIB_LINUXCONF)/help.eng/$(CURDIR)-msg-$(PACKAGE_REV).eng eE \
		$(CURDIR)
	@if [ -d messages ] ; then \
		for file in messages/*.dic; do \
			if [ -f "$$file" ] ; then \
				LANGID=`basename $$file .dic`; \
				mkdir -p $(LIB_LINUXCONF)/help.$$LANGID; \
				ln -sf $$LANGID.dic messages/$(CURDIR).dic; \
				$(MSGCOMP) -p./ -pmessages/ \
					$(LIB_LINUXCONF)/help.$$LANGID/$(CURDIR)-msg-$(PACKAGE_REV).$$LANGID TE \
					$(CURDIR); \
				rm -f messages/$(CURDIR).dic; \
				fi; \
			done; \
		fi
	@if [ -f $(CURDIR).xpm ]; then \
		echo installing $(LIB_LINUXCONF)/images/$(CURDIR).xpm; \
		install -o root -g root -m 644 $(CURDIR).xpm $(LIB_LINUXCONF)/images; \
		fi
	@if [ -f $(CURDIR).gif ]; then \
		echo installing $(LIB_LINUXCONF)/images/$(CURDIR).gif; \
		install -o root -g root -m 644 $(CURDIR).gif $(LIB_LINUXCONF)/images; \
		fi


install_daemons:
	mkdir -p $(LIB_LINUXCONF)/redhat $(LIB_LINUXCONF)/caldera $(LIB_LINUXCONF)/suse \
		$(LIB_LINUXCONF)/conectiva $(LIB_LINUXCONF)/debian $(LIB_LINUXCONF)/std
	$(COPYDIR) redhat	$(LIB_LINUXCONF)
	$(COPYDIR) conectiva $(LIB_LINUXCONF) redhat
	$(COPYDIR) suse		$(LIB_LINUXCONF)
	$(COPYDIR) caldera	$(LIB_LINUXCONF)
	$(COPYDIR) debian	$(LIB_LINUXCONF)
	$(COPYDIR) std		$(LIB_LINUXCONF)

install_helps:
	for p in help.files/*/Makefile; do cd `dirname $$p`; make install; cd ../..; done

# Rules to build RPM, for module developped outside of the linuxconf source tree

MODULE_REV=$(VERSION)
SOURCEDIR=$(CURDIR)-$(MODULE_REV)


buildrpm: buildspec buildsrc
	unset LD_PRELOAD ; rpm -ba /usr/src/redhat/SPECS/$(CURDIR)-$(MODULE_REV).spec

buildspec:
	grep MODULE_API_VERSION /usr/include/linuxconf/module.h | \
		( read a b MODULEREV && \
		sed s/MODULENAME/$(CURDIR)/ $(RPMSPEC) \
			| sed s/PACKAGEREV/$(MODULE_REV)/ \
			| sed s/SOURCE/$(SOURCEDIR).src.tar.gz/ \
			| sed s/LINUXCONFAPIREV/LINUXCONFAPIREV$$MODULEREV/ \
			| $(FILTERSPEC) >/usr/src/redhat/SPECS/$(SOURCEDIR).spec \
		)

buildsrc:
	rm -fr /tmp/$(SOURCEDIR)
	mkdir /tmp/$(SOURCEDIR)
	cp -a . /tmp/$(SOURCEDIR)/.
	(cd /tmp/$(SOURCEDIR) && make clean)
	(cd /tmp && tar zcvf /usr/src/redhat/SOURCES/$(SOURCEDIR).src.tar.gz $(SOURCEDIR) )
	rm -fr /tmp/$(SOURCEDIR)

