#include <unistd.h>
#include "status.h"
#include "popen.h"
#include "status.m"
#include "daemoni.h"
#include <netconf.h>
#include <module_apis/status_apidef.h>

static int sys_command_raw (
	const char *cmd,
	const char *args,
	SSTRINGS &tb)
{
	int ret = -1;
	POPEN pop (cmd,args);
	if (pop.isok()){
		char buf[1000];
		buf[0] = buf[1] = buf[2] = ' ';
		while (pop.wait(10) > 0){
			char tmp[1000];
			while (pop.readout(tmp,sizeof(tmp))!=-1){
				str_exptab (tmp,8,buf+3);
				tb.add (new SSTRING(buf));
			}
		}
		ret = 0;
	}else{
		xconf_error (MSG_U(E_CANTEXEC,"Can't execute the command\n%s"),cmd);
	}
	return ret;
}

int sys_command (
	const char *cmd,
	const char *args,
	SSTRINGS &tb)
{
	int ret = -1;
	const char *path = cmd;
	if (path[0] != '/'){
		DAEMON_INTERNAL *dae = daemon_find (cmd);
		if (dae == NULL){
			path = NULL;
		}else{
			path = dae->getpath();
		}
	}
	if (path != NULL){
		char title[PATH_MAX+100];
		snprintf (title,sizeof(title)-1
			,"%s: %s %s",MSG_U(I_OUTPUT,"Output of command")
			,path,args);
		tb.add (new SSTRING(title));
		ret = sys_command_raw (cmd,args,tb);
	}
	return ret;
}


static int sys_showfile (
	const char *file,
	SSTRINGS &tb)
{
	char title[PATH_MAX+100];
	snprintf (title,sizeof(title)-1,"%s %s",MSG_U(I_FILE,"File"),file);
	tb.add (new SSTRING(title));
	return sys_command_raw ("cat",file,tb);
}

void sys_command_title (
	const char *title,
	const char *cmd,
	const char *args)
{
	SSTRINGS tb;
	if (sys_command (cmd,args,tb) != -1){
		dialog_textbox (title,tb);
	}
}



void sys_memory_show()
{
	sys_command_title (MSG_R(M_MEMORY),"free","");
}

void sys_disk_show()
{
	sys_command_title (MSG_R(M_DISK),"df","");
}

void sys_scsi_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/scsi/scsi",tb) != -1){
		dialog_textbox (MSG_R(M_SCSI),tb);
	}
}

void sys_md_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/mdstat",tb) != -1){
		dialog_textbox (MSG_R(M_MD),tb);
	}
}

void sys_inter_show()
{
	sys_command_title (MSG_R(M_INTERFACE),"ifconfig","");
}

void sys_iprouting_show()
{
	sys_command_title (MSG_R(M_IPROUTING),"route","-n");
}

void sys_ipxrouting_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/net/ipx_route",tb) != -1){
		dialog_textbox (MSG_R(M_IPXROUTING),tb);
	}
}

void sys_interrupts_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/interrupts",tb) != -1){
		dialog_textbox (MSG_R(M_INTERRUPTS),tb);
	}
}

void sys_ioports_show()
{
	SSTRINGS tb;
	if (sys_showfile ("/proc/ioports",tb) != -1){
		dialog_textbox (MSG_R(M_IOPORTS),tb);
	}
}

void sys_sysinfo_show()
{
	SSTRINGS tb;
	SSTRING *ver = new SSTRING;
	ver->setfromf ("Linuxconf %s",PACKAGE_REV);
	tb.add (ver);
	SSTRING *name = new SSTRING;
	char hostname[PATH_MAX];
	if (gethostname(hostname,sizeof(hostname)-1)==-1){
		hostname[0] = '\0';
	}
	name->setfromf (MSG_U(I_HOSTNAMEIS,"Host name: %s"),hostname);
	tb.add (name);
	
	sys_showfile ("/proc/version",tb);
	sys_command  ("uptime","",tb);
	sys_showfile ("/proc/cpuinfo",tb);
	dialog_textbox (MSG_R(M_SYSINFO),tb);
}

void sys_processes_show ()
{
	sys_command_title (MSG_R(M_PROCESSES),"pstree","");
}

void sys_pci_show()
{
	SSTRINGS tb;
/* with kernel 2.2 we could use pciutils I think to give something more user-readable */
	if (sys_showfile ("/proc/pci",tb) != -1){
		dialog_textbox (MSG_R(M_PCI),tb);
	}
}

static void sys_showfile_title (const char *title, const char *path)
{
	SSTRINGS tb;
	if (sys_showfile (path,tb) != -1){
		dialog_textbox (title,tb);
	}
}


void *status_api_get ()
{
	STATUS_API *api = new STATUS_API;
	api->showcommand = sys_command_title;
	api->showfile = sys_showfile_title;
	return api;
}

void status_api_release (void *api)
{
	delete (STATUS_API*)api;
}

