#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include <subsys.h>
#include "inetdconf.h"
#include "inetdconf.m"
#include <module_apis/servicectl_api.h>


static void inetdconf_menu( void );
static const char *keymenu=NULL;
static HELP_FILE help_inetdconf ("inetdconf","inetdconf");

MODULE_DEFINE_VERSION(inetdconf);
PUBLIC MODULE_inetdconf::MODULE_inetdconf()
	: LINUXCONF_MODULE("inetdconf")
{
	linuxconf_loadmsg ("inetdconf",PACKAGE_REV);
	module_register_api (SERVICECTL_API_KEY,SERVICECTL_API_REV
		,inetdconf_api_get,inetdconf_api_release);
}

PUBLIC void MODULE_inetdconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
//fprintf(stderr,"setmenu\n");
		keymenu = MSG_U(M_INETDCONFS,"Internet services");
		dia.new_menuitem ("inetdconf","",keymenu);
	}
}

PUBLIC int MODULE_inetdconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
//fprintf(stderr,"domenu: key=%s\n", key);
		if (key == keymenu){
			inetdconf_menu();
		}
	}
	return 0;
}


PUBLIC int MODULE_inetdconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"inetdconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module inetdconf usage\n"
		 "\n"
		 "    --enable service [service ...]\n"
		 "    --disable service [service ...]\n"
		)
		);
}

PUBLIC void MODULE_inetdconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_inetdconf::execmain (int argc , char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"inetdconf")==0){
		ret = -1;
		if (argc == 1) {
			inetdconf_edit( );
		} else {
			if ( argc > 2 ) {
				if ( strcmp( argv[1],"--enable" ) == 0 ) {
					argc -= 2; argv++; argv++;
					inetdconf_enable_service( argc, argv,1 );
				} else if ( strcmp( argv[1],"--disable" ) == 0 ) {
					argc -= 2; argv++; argv++;
					inetdconf_enable_service( argc, argv,0 );
				} else {
					::usage();
				}
			} else {
				::usage();
			}
		}
	}
	return ret;
}


static MODULE_inetdconf inetdconf;

static void inetdconf_menu( void )
{
	static const char *m_etcservice = MSG_U(M_ETCSERVICE,"Internet network services");
	static const char *m_inetdconf = MSG_U(M_INETDCONFS_INETD,"Internet servers database");
	static const char *m_firewall = MSG_U(M_FIREWALL,"Internet firewall and masquerade");
	static const char *m_hostsallow = MSG_U(M_HOSTSALLOW,"Allowed server access");
	static const char *m_hostsdeny = MSG_U(M_HOSTSDENY,"Denied server access");
	static const char *menuopt[] = {
		"",		m_etcservice,
		"",		m_inetdconf,
		"",		m_firewall,
		"",		m_hostsallow,
		"",		m_hostsdeny,
                NULL,
        };
	DIALOG_MENU dia;
	dia.new_menuitems (menuopt);
	int choice=0;
	while( 1 ) {
		MENU_STATUS code = dia.editmenu (MSG_U(M_INETDCONFS_MENU, "Basic services")
			,MSG_U(I_INETD,
			"This menu allows you to configure basic system services\n"
			"based on the internet super server inetd and do a\n"
			"simple firewall against the internet with internal\n"
			"masquerading of the local network.\n"
			"\n"
			"For servers which are started by inetd/tcpd it is also\n"
			"possible to allow or deny servers on a system basis."
			)
			,help_inetdconf
			,choice,0);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else{
//fprintf(stderr,"inetdconf_menu code=%d choice=%d\n", code, choice);
			const char *key = menuopt[choice*2+1];
			if (key == m_etcservice) {
				etcservice_edit( );
			} else if (key == m_inetdconf) {
				inetdconf_edit( );
			} else if (key == m_firewall) {
				firewall_edit( );
			} else if (key == m_hostsallow) {
				hostsallow_edit( );
			} else if (key == m_hostsdeny) {
				hostsdeny_edit( );
			}
		}
	}	
}

