#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "misc.h"

/*
	Copy one word from a string. A word is a sequence of non white space.
	Return a pointer on the first blank character after the word.

	If there were no word, dest[0] == '\0'
*/

char *str_copyword(char *dest, const char *str)
{
	if (str != NULL){
		str = str_skip(str);
		while (*str > ' ') *dest++ = *str++;
	}
	*dest = '\0';
	return (char*) str;
}
char *str_copyword(char *dest, const char *str, int size)
{
	if (str != NULL){
		str = str_skip(str);
		size--;
		while (*str > ' ' && size > 0){
			*dest++ = *str++;
			size--;
		}
	}
	*dest = '\0';
	return (char*) str;
}

/*
	Check if a string start with a given word followed by a space or '\0';
	Return != 0 if this is true.
*/
int str_isword (const char *str, const char *word)
{
	int len = strlen (word);
	int ret = strncmp(str,word,len)==0;
	if (ret){
		char car = str[len];
		ret = (isspace(car) || car == '\0');
	}
	return ret;
}

/*
	Like strncpy but make sure the '\0' is there
	size if the sizeof() of the destination. One byte is kept to put
	the '\0';
*/
void strcpy_cut (char *dst, const char *src, int size)
{
	if (size >= 0){
		if (size > 0){
			size--;
			strncpy (dst,src,size);
		}
		dst[size] = '\0';
	}
}
/*
	Move over one word
*/

char *str_skipword(const char *str)
{
	str = str_skip(str);
	while (*str > ' ') str++;
	str = str_skip(str);
	return (char*) str;
}
/*
	Copy one word from a string. A word is a sequence of non white space.
	Return a pointer on the first blank character after the word.

	If there were no word, dest[0] == '\0'
*/

char *str_copyword(SSTRING &dest, const char *str)
{
	str = str_skip(str);
	char tmp[1000];
	char *pt = tmp;
	while (*str > ' ') *pt++ = *str++;
	*pt = '\0';
	dest.setfrom (tmp);
	return (char*) str;
}

/*
	Free all entry of the string table.
*/
void tbstr_free (char *tb[], int nb)
{
	for (int i=0; i<nb; i++) free (tb[i]);
}

/*
	Why is it missing ?
*/
int stricmp (const char *str1, const char *str2)
{
	int ret = 0;
	while (1){
		if (*str1 == '\0'){
			if (*str2 != 0){
				ret = -1;
			}
			break;
		}else if (*str2 == '\0'){
			ret = 1;
			break;
		}else{
			int car1 = toupper(*str1);
			int car2 = toupper(*str2);
			ret = car1 - car2;
			if (ret != 0) break;
			str1++;
			str2++;
		}
	}
	return ret;
}


void strupr(char *str)
{
	while (*str != '\0'){
		*str = toupper(*str);
		str++;
	}
}

/*
	Extract a string from a buffer.
	The string may be a single word or many words enclose in
	double quote.
*/
const char *str_extract (const char *buf, SSTRING &s)
{
	buf = str_skip(buf);
	char word[200];
	if (*buf == '"'){
		buf++;
		char *pt = word;
		while (*buf != '\0' && * buf != '"') *pt++ = *buf++;
		*pt = '\0';
		if (*buf == '"') buf++;
	}else{
		buf = str_copyword (word,buf);
	}
	s.setfrom (word);
	return buf;
}

/*
	Decompose a record in separate field (like /etc/passwd)
	Spaces between words are skiped.
	Words are limited to 99 characters.

	Return the number of field written in words
*/
int str_splitline (
	const char *line,	// Line to split
	char delim,			// Field delimiter
	SSTRINGS &words)	// Will contain the separated words
{
	int start = words.getnb();
	while (1){
		line = str_skip(line);
		if (*line == '\0'){
			break;
		}else{
			char word[100];
			char *pt = word;
			while (*line > ' ' && *line != delim
				&& (pt-word) < 99) *pt++ = *line++;
			*pt = '\0';
			// Forget the rest of a word which is too long (this must be
			// crap anyway and not expected by the caller)
			while (*line > ' ' && *line != delim) line++;
			if (*line == delim) line++;
			if (word[0] != '\0') words.add (new SSTRING(word));
		}			
	}
	return words.getnb()-start;
}

