#pragma implementation
#include <limits.h>
#include "context.h"
#include <stdio.h>
#include "misc.h"

LINUXCONF_CONTEXT ui_context;

/*
	Return true if we are operating in the main admin tree
*/
bool context_isroot()
{
	return strcmp(ui_context.basepath,"/")==0;
}

void context_setabspath (const char *path, char abspath[])
{
	if (context_isroot()){
		strcpy (abspath,path);
	}else{
		snprintf (abspath,PATH_MAX,"%s%s",ui_context.basepath,path);
	}
}

PRIVATE void LINUXCONF_CONTEXT::init()
{
	strcpy (basepath,"/");
	tb = NULL;
	linuxconf_date = 0;
	title_prefix[0] = '\0';
	treejump_level = 0;
	treemenu_level = 0;
	defpriv = NULL;
}

PUBLIC LINUXCONF_CONTEXT::LINUXCONF_CONTEXT (const char *_path)
{
	init();
	strcpy (basepath,_path);
}
PUBLIC LINUXCONF_CONTEXT::LINUXCONF_CONTEXT ()
{
	init();
}

PUBLIC void LINUXCONF_CONTEXT::set (LINUXCONF_CONTEXT &cur)
{
	strcpy (basepath,cur.basepath);
	tb = cur.tb;
	linuxconf_date = cur.linuxconf_date;
	configf_forgetpath();
	strcpy (title_prefix,cur.title_prefix);
	treejump_level = cur.treejump_level;
	treemenu_level = cur.treemenu_level;
	defpriv = cur.defpriv;
}

PUBLIC void LINUXCONF_CONTEXT::settitle (const char *title)
{
	strcpy (title_prefix,title);
}

/*
	Create a directory in the current admin tree
*/
int context_mkdir (
	const char *dir,
	const char *user,
	const char *group,
	int perm)
{
	char abspath[PATH_MAX];
	context_setabspath(dir,abspath);
	return file_mkdir (abspath,user,group,perm);
}
/*
	Create a directory in the current admin tree
*/
int context_mkdirp (
	const char *dir,
	const char *user,
	const char *group,
	int perm)
{
	char abspath[PATH_MAX];
	context_setabspath(dir,abspath);
	return file_mkdirp (abspath,user,group,perm);
}

/*
	Create an empty file in the current admin tree
*/
int context_create (
	const char *path,
	const char *user,
	const char *group,
	int perm)
{
	char abspath[PATH_MAX];
	context_setabspath(path,abspath);
	return file_create (abspath,user,group,perm);
}
/*
	Check if a file or directory exist in the current admin tree
*/
bool context_fexist(const char *path)
{
	char abspath[PATH_MAX];
	context_setabspath(path,abspath);
	return file_exist (abspath);
}
