#pragma interface
#ifndef CONFIGF_H
#define CONFIGF_H

#include <limits.h>

/*
	This class record help file path and serve as a runtime check
	that there is no help file missing.
*/
class HELP_FILE{
	friend void helpf_checkall();
	const char *subdir;
	const char *fname;
	char *path;		// Dynamically allocated buffer containing
					// the resolved path.
	HELP_FILE *next;
	/*~PROTOBEG~ HELP_FILE */
public:
	HELP_FILE (const char *_subdir, const char *_fname);
	const char *getpath (void);
private:
	void getpaths (char abspath[PATH_MAX],
		 char relpath[PATH_MAX]);
public:
	void getrpath (char *rpath);
	/*~PROTOEND~ HELP_FILE */
};

extern HELP_FILE help_nil;	// Object to specify that there is
							// no help file available.

// #Specbeg: CONFIG_FILE / status bits definition
#define CONFIGF_NONE		0
#define CONFIGF_MANAGED		1		// linuxconf do edit this file
#define CONFIGF_PRIVATE		2		// Only root can see this
#define CONFIGF_OPTIONAL	4		// Don't complain if the file
									// is missing.
#define CONFIGF_OPTIONNAL	CONFIGF_OPTIONAL	// Old error
#define CONFIGF_GENERATED	8		// linuxconf do not edit
									// the file, but generate it.
#define CONFIGF_PROBED		16		// This file is checked to
									// control a daemon						
#define CONFIGF_ERASED		32		// Erased at boot time
#define CONFIGF_SIGNPOUND	64		// Write a linuxconf signature
									// when opening the file for writing
#define CONFIGF_NOARCH		128		// This file must not be archived
#define CONFIGF_VIRTUAL		256		// Logical view of a configuration file
									// used for archiving and remote admin
#define CONFIGF_DIST		512		// The file is not archived directly
									// but is distributed in various sub-systems
#define CONFIGF_TMPLOCK		1024	// The file is saved in a temporary file
									// and then renamed atomically in place
#define CONFIGF_FIXEDBASE	2048	// This file can't be relocated to
									// an admin tree (this was really
									// created for /var/log/netconf.log)
// #Specend:

class PRIVILEGE;
class SSTRINGS;
class SSTREAM;

class CONFIG_FILE{
	friend void configf_show();
	friend void configf_booterase();
	class CONFIG_FILE_INTERNAL *intern;
	/*~PROTOBEG~ CONFIG_FILE */
public:
	CONFIG_FILE (const char *_path,
		 HELP_FILE&_helpfile,
		 int _status);
	CONFIG_FILE (const char *_path,
		 HELP_FILE&_helpfile,
		 int _status,
		 const char *_owner,
		 const char *_group,
		 int _perm);
	CONFIG_FILE (const char *_path,
		 HELP_FILE&_helpfile,
		 int _status,
		 const char *_owner,
		 const char *_group,
		 int _perm,
		 const char *_subsys);
	CONFIG_FILE (const char *_path,
		 HELP_FILE&_helpfile,
		 int _status,
		 const char *_subsys);
protected:
	virtual int archive (SSTREAM&ss)const;
public:
	virtual int archive (void)const;
	int create (void)const;
	int editpath (void);
	int exist (void)const;
	virtual int extract (SSTREAM&ss);
	virtual int extract (void);
	int fclose (FILE *fout);
private:
	void fixpath (void)const;
public:
	FILE *fopen (PRIVILEGE *priv,
		 const char *mode)const;
	FILE *fopen (PRIVILEGE *priv,
		 const char *temp,
		 const char *mode)const;
	FILE *fopen (const char *mode)const;
	FILE *fopen (const char *temp,
		 const char *mode)const;
	FILE *fopen_ok (const char *mode)const;
	FILE *fopen_tmp (PRIVILEGE *priv,
		 const char *mode)const;
	void forgetpath (void);
	long getdate (void)const;
	const char *gethelp (void)const;
	CONFIG_FILE *getnext (void)const;
	const char *getpath (void)const;
	const char *getstdpath (void)const;
	const char *getsubsys (void)const;
private:
	void init (HELP_FILE&_helpfile,
		 const char *_path,
		 int _status,
		 const char *_owner,
		 const char *_group,
		 int _perm,
		 const char *_subsys);
public:
	int is_archived (void)const;
	int is_erased (void)const;
	int is_generated (void)const;
	int is_managed (void)const;
	int is_optionnal (void)const;
	int is_probed (void)const;
	int is_virtual (void)const;
	virtual int md5sum (char *sum);
	int relink_tmp (void);
protected:
	void setkey (const char *newkey);
public:
	int setperm (const char *fpath)const;
private:
	void sign (FILE *fout, const char *mode)const;
public:
	int unlink (void)const;
	virtual ~CONFIG_FILE (void);
	/*~PROTOEND~ CONFIG_FILE */
};

// Used for package to declare CONFIG_FILE which should appear in
// the list of config file. This is handy for archiving
class CONFIG_FILE_LISTER{
public:
	CONFIG_FILE_LISTER *next;
	void (*fct)();
	/*~PROTOBEG~ CONFIG_FILE_LISTER */
public:
	CONFIG_FILE_LISTER (void (*f)());
	/*~PROTOEND~ CONFIG_FILE_LISTER */
};

#define ARCHIVE_NOFILE		"### no file ###"
#define ARCHIVE_NOARCH		"### no arch ###"
#define ARCHIVE_FILEEXIST	"### file exist ###"

#endif
