#pragma interface
#ifndef CONFDB_H
#define CONFDB_H

#ifndef MISC_H
	#include "misc.h"
#endif

class PRIVILEGE;

class CONFOBJ: public ARRAY_OBJ{
public:
	const char *sys;		// Pointer from tbsys[] below or NULL
	SSTRING key;
	SSTRING val;
	/*~PROTOBEG~ CONFOBJ */
public:
	CONFOBJ (const char *_sys,
		 const char *_key,
		 const char *_val);
	/*~PROTOEND~ CONFOBJ */
};

struct CONFDB_INTERNAL;

class CONFDB: public ARRAY{
	CONFDB_INTERNAL *internal;
	/*~PROTOBEG~ CONFDB */
public:
	CONFDB (CONFIG_FILE&_fcfg);
	CONFDB (CONFIG_FILE&_fcfg,
		 bool use_equal_sign,
		 const char comcar);
	CONFDB (void);
	void add (const char *prefix,
		 const char *key,
		 bool val);
	void add (const char *prefix,
		 const char *key,
		 const SSTRING&val);
	virtual void add (const char *prefix,
		 const char *key,
		 const char *val);
	void add (const char *prefix,
		 const char *key,
		 int val);
private:
	void addk (const char *key, const char *val);
public:
	void addline (const char *buf);
	virtual int archive (SSTREAM&ss, const char *_sys);
private:
	void delsys (const char *_sys);
public:
	virtual int extract (SSTREAM&ss, const char *_sys);
	virtual int getall (const char *prefix,
		 const char *key,
		 SSTRINGS&lst,
		 bool copy);
	CONFOBJ *getitem (int no);
	const char *getval (const char *prefix,
		 const char *key);
	virtual const char *getval (const char *prefix,
		 const char *key,
		 const char *defval);
	double getvalf (const char *prefix,
		 const char *key,
		 double defval);
	virtual const char *getvalk (const char *key,
		 const char *defval);
	int getvalnum (const char *prefix,
		 const char *key,
		 int defval);
private:
	void init (void);
public:
	void initload (CONFIG_FILE&_fcfg,
		 bool use_equal_sign,
		 const char comcar);
private:
	char *locatesys (const char *sys);
public:
	void patchsys (void);
	virtual void removeall (const char *prefix,
		 const char *key);
private:
	void removeallk (const char *key);
public:
	void replace (const char *prefix,
		 const char *key,
		 bool val);
	void replace (const char *prefix,
		 const char *key,
		 char val);
	void replace (const char *prefix,
		 const char *key,
		 const SSTRING&val);
	void replace (const char *prefix,
		 const char *key,
		 const SSTRINGS&vals);
	void replace (const char *prefix,
		 const char *key,
		 const char *val);
	void replace (const char *prefix,
		 const char *key,
		 double val);
	void replace (const char *prefix,
		 const char *key,
		 int val);
	void replace (const char *prefix,
		 const char *key,
		 long val);
	void replacek (const char *key, const char *val);
	virtual int save (PRIVILEGE *priv);
	int save (void);
private:
	void savesys (char *sys, SSTREAM&ss);
public:
	virtual void setcursys (const char *_subsys);
	virtual void setcursys (const char *_subsys,
		 bool _subsys_scope);
	~CONFDB (void);
	/*~PROTOEND~ CONFDB */
};


#endif

