#include "diawxxt.h"


PUBLIC SHEET::SHEET (
	FORMBASE *_parent,
	const char *_id,
	int _nbcol,
	const char *_cols[])
	: MFORM (_parent,_id)
{
	sub = new MFORM(this,"");
	New_form(sub);
	nbcol = _nbcol;
	cols = new char *[_nbcol];
	wxDC *dc = GetDC();
	int maxh = 0;
	for (int i=0; i<_nbcol; i++){
		const char *s = _cols[i];
		cols[i] = strdup(s);
		float w,h;
		dc->GetTextExtent (s,&w,&h);
		int wi = (int)w+5;
		int hi = (int)h;
		sub->mincols[i] = wi;
		if (hi > maxh) maxh = hi;
	}
	marge_droite = marge_gauche = 5;
	marge_haut = maxh + 5;
	marge_bas = 5;
}

PUBLIC SHEET::~SHEET ()
{
	for (int i=0; i<nbcol; i++){
		free (cols[i]);
	}
	delete [] cols;
}

/*
	Add a new line
*/
PUBLIC void SHEET::New_item (
	int row,
	int column,
	const char *val)
{
	sub->New_string (30,val);
	if (column == nbcol -1) sub->Newline();
}

/*
	Draw the heading of the list and the decoration around the list.
*/
PUBLIC void SHEET::drawhead()
{
	wxDC *dc = GetDC();
	int x = 8;
	float w,h;
	dc->GetTextExtent ("WWW",&w,&h);
	int y = (int)h+2;
	for (int i=0; i<nbcol; i++){
		dc->SetPen (pen_black);
		dc->DrawText (cols[i],x,0);
		int width = sub->colwidth[i];
		dc->DrawLine (x,y,x+width-4,y);
		x += width;
	}
}
PUBLIC void SHEET::OnPaint()
{
	MFORM::OnPaint();
	drawhead();
}


PUBLIC void SHEET::dump()
{
	char path[300];
	formbase_getabspath(this,path);
	int nbline = sub->nbc/(nbcol+1);	// nbc has also the Newline field
	fprintf (mform_fout,"dump %s %s %d\n",path,id,nbline);
	int item = 0;
	for (int i=0; i<nbline; i++){
		for (int j=0; j<=nbcol; j++, item++){
			MFORM_C *c = sub->tbc[item];
			if (c->type == T_STRING){
				const char *val = ((wxText*)c->c)->GetValue();
				fprintf (mform_fout,"dump %s %s-%d-%d %s\n",path,id,i,j,val);
			}
		}
	}	
}

