#pragma interface
#ifndef DIALOG_H
#define DIALOG_H

#include <curses.h>
#include <stdarg.h>

#include "dialog_def.h"

#ifndef MISC_H
	#include <misc.h>
#endif
	
class BUTTONS_INFO;
class SSTRINGS;
class HELP_FILE;

class FIELD_MSG{
public:
	char is_loaded;		// Is there a message to process
	void *key;			// Generally a pointer to a common
						// data used by field to talk to each other
	int  int_val;		// Value of the message
						// It is expected to see other type
						// to communicate more complex messages
						// between fields.
	/*~PROTOBEG~ FIELD_MSG */
public:
	FIELD_MSG (void);
	/*~PROTOEND~ FIELD_MSG */
};

class FIELD: public ARRAY_OBJ{
protected:
	bool readonly;		// This field can't be modified
	bool maybeempty;
	bool may_select;	// For Menu field
	bool is_head;		// Is a heading
	friend class DIALOG;
	friend class DIALOG_LISTE;
	friend class DIALOG_RECORDS;
	friend class DIALOG_MENU;
	char *prompt;
	int  vsize;		// Number of lines used by the field (normally 1)
					// may be 0
public:
	struct {
		int x;	// Horizontal position of the input boxes
		int width;
		int y;	// Vertical coordinate of the input boxes
	} box;
public:		     	
	virtual void drawtxt(WINDOW *)=0;
	virtual void dokey(WINDOW *, int key, FIELD_MSG &msg)=0;
	virtual void save()=0;
	virtual void restore()=0;
	virtual void reload(const char *dianame, int nof)=0;
	virtual void html_draw(int nofield)=0;
	virtual void gui_draw(int nofield, int &booklevel)=0;
	virtual void gui_get(int nofield)=0;
	virtual char getidprefix ()=0;
	virtual int html_validate(int nofield)=0;
	/*~PROTOBEG~ FIELD */
public:
	FIELD (const char *_prompt);
	void draw (WINDOW *dialog);
	virtual void format_htmlkey (char *key, int nof);
	virtual const char *getmenustr (void)const;
	virtual int getnotepadlevel (void)const;
protected:
	virtual int getwidths (int [], int &);
public:
	virtual bool is_passthrough (void);
	bool is_readonly (void);
	virtual bool is_selectable (void);
	virtual int post_validate (void);
protected:
	virtual void processmsg (WINDOW *, FIELD_MSG&, int);
	void sendval (const char *dianame,
		 int nof,
		 char type,
		 const char *val);
	void sendval (const char *dianame,
		 int nof,
		 char type,
		 int val);
public:
	virtual void set_noempty (void);
	void set_readonly (void);
	virtual void set_selectable (bool _may_select);
	virtual void setcursor (WINDOW *dialog);
protected:
	virtual void setwidths (int , int []);
public:
	virtual void unselect (WINDOW *);
	virtual ~FIELD (void);
	/*~PROTOEND~ FIELD */
};

class FIELD_STRING_BASE: public FIELD{
protected:
	friend class DIALOG;
	struct {
		int input;	// Current position in window */
		int scroll;	// Amount of horizontal scrolling so far */
	}x;
	int size;
	char *buf;		// For editing
protected:
	int password_mode;	// Echo on or not
	int fwidth;		// Recommended visible width of the text field
	/*~PROTOBEG~ FIELD_STRING_BASE */
protected:
	FIELD_STRING_BASE (const char *_prompt,
		 const char *_str,
		 int maxsiz);
	FIELD_STRING_BASE (const char *_prompt,
		 int maxsiz);
public:
	void dokey (WINDOW *dialog,
		 int key,
		 FIELD_MSG&);
	void drawtxt (WINDOW *dialog);
	char getidprefix (void);
	void gui_draw (int nof, int &);
	void gui_get (int nof);
	void html_draw (int nof);
	int html_validate (int nof);
private:
	void init (int maxsiz);
public:
	bool is_empty (void);
	int post_validate (void);
	void setcursor (WINDOW *dialog);
	~FIELD_STRING_BASE (void);
	/*~PROTOEND~ FIELD_STRING_BASE */
};

class FIELD_STRING: public FIELD_STRING_BASE{
protected:
	char *str;		// String to edit
	char *backup;
	/*~PROTOBEG~ FIELD_STRING */
public:
	FIELD_STRING (const char *_prompt,
		 char *_str,
		 int maxsiz);
	void reload (const char *dianame, int nof);
	void restore (void);
	void save (void);
	~FIELD_STRING (void);
	/*~PROTOEND~ FIELD_STRING */
};

class SSTRING;
class FIELD_SSTRING: public FIELD_STRING_BASE{
protected:
	SSTRING &str;
	SSTRING backup;
	/*~PROTOBEG~ FIELD_SSTRING */
public:
	FIELD_SSTRING (const char *_prompt,
		 SSTRING&_str,
		 int field_width);
	void html_draw (int nof);
	void reload (const char *dianame, int nof);
	void restore (void);
	void save (void);
	/*~PROTOEND~ FIELD_SSTRING */
};

class FIELD_PASSWORD: public FIELD_SSTRING{
	/*~PROTOBEG~ FIELD_PASSWORD */
public:
	FIELD_PASSWORD (const char *_prompt,
		 SSTRING&_str);
	/*~PROTOEND~ FIELD_PASSWORD */
};


// FIELD_STRING with a helper hot key
// generally used to setup combo-box
class FIELD_STRING_HELP: public FIELD_SSTRING{
protected:
	virtual void assist(WINDOW *dialog)=0;
	/*~PROTOBEG~ FIELD_STRING_HELP */
public:
	FIELD_STRING_HELP (const char *_prompt,
		 SSTRING&_str);
	void dokey (WINDOW *dialog,
		 int key,
		 FIELD_MSG&msg);
	void drawtxt (WINDOW *dialog);
	/*~PROTOEND~ FIELD_STRING_HELP */
};

class LIST_STR;
class FIELD_COMBO: public FIELD_STRING_HELP{
protected:
	LIST_STR *opts;
	int listvalueonly;
	/*~PROTOBEG~ FIELD_COMBO */
public:
	FIELD_COMBO (const char *_prompt, SSTRING&_str);
	void addopt (const char *str);
	void addopt (const char *value,
		 const char *verbose);
protected:
	void assist (WINDOW *dialog);
public:
	char getidprefix (void);
	void gui_draw (int nof, int &);
	void gui_get (int nof);
	void html_draw (int nof);
	int html_validate (int nof);
	~FIELD_COMBO (void);
	/*~PROTOEND~ FIELD_COMBO */
};
class FIELD_LIST: public FIELD_COMBO{
	/*~PROTOBEG~ FIELD_LIST */
public:
	FIELD_LIST (const char *_prompt, SSTRING&_str);
	void dokey (WINDOW *dialog, int , FIELD_MSG&);
	virtual int post_validate (void);
	/*~PROTOEND~ FIELD_LIST */
};
class FIELD_ENUM: public FIELD_LIST{
	int &sel;
	int backup_sel;
	/*~PROTOBEG~ FIELD_ENUM */
public:
	FIELD_ENUM (const char *_prompt, int &_sel);
	void addopt (const char *str);
	void addopt (const char *value,
		 const char *verbose);
	void reload (const char *dianame, int nof);
	void restore (void);
	void save (void);
	/*~PROTOEND~ FIELD_ENUM */
};

class FIELD_COMBO_MANY: public FIELD_COMBO{
	/*~PROTOBEG~ FIELD_COMBO_MANY */
public:
	FIELD_COMBO_MANY (const char *_prompt,
		 SSTRING&_str);
	void addopt (const char *str, char &selected);
protected:
	void assist (WINDOW *dialog);
public:
	/*~PROTOEND~ FIELD_COMBO_MANY */
};

class FIELD_CHECK_RADIO: public FIELD{
protected:
	char *title;
	char *var;
	char val;
	char backup;
	/*~PROTOBEG~ FIELD_CHECK_RADIO */
public:
	FIELD_CHECK_RADIO (const char *_prompt,
		 char &_var,
		 const char *_title);
	void drawtxt_check (WINDOW *dialog,
		 char openchar,
		 char closechar,
		 char selchar);
	void format_htmlkey (char *key, int nof);
	void reload (const char *dianame, int nof);
	void restore (void);
	void save (void);
	void setcursor (WINDOW *dialog);
	~FIELD_CHECK_RADIO (void);
	/*~PROTOEND~ FIELD_CHECK_RADIO */
};


class FIELD_CHECK: public FIELD_CHECK_RADIO{
	/*~PROTOBEG~ FIELD_CHECK */
public:
	FIELD_CHECK (const char *_prompt,
		 char &_var,
		 const char *_title);
	void dokey (WINDOW *dialog, int key, FIELD_MSG&);
	void drawtxt (WINDOW *dialog);
	char getidprefix (void);
	void gui_draw (int nof, int &);
	void gui_get (int nof);
	void html_draw (int nof);
	int html_validate (int nof);
	/*~PROTOEND~ FIELD_CHECK */
};
class FIELD_RADIO: public FIELD_CHECK_RADIO{
	char instance_val;
	FIELD_RADIO *next;		// All field radio are in a linked list
							// see radio.c
	/*~PROTOBEG~ FIELD_RADIO */
public:
	FIELD_RADIO (const char *_prompt,
		 char &_var,
		 char _instance_val,
		 const char *_title);
	void dokey (WINDOW *, int key, FIELD_MSG&msg);
	void drawtxt (WINDOW *dialog);
	char getidprefix (void);
	void gui_draw (int , int &);
	void gui_get (int);
	void html_draw (int);
	int html_validate (int);
private:
	FIELD_RADIO *locate_key (char *key);
protected:
	void processmsg (WINDOW *dialog,
		 FIELD_MSG&msg,
		 int drawok);
public:
	~FIELD_RADIO (void);
	/*~PROTOEND~ FIELD_RADIO */
};
#define DIALOG_MAXCOL	20

class FIELD_CHECK_MULTI: public FIELD{
protected:
	SSTRINGS options;
	char *var;
	char val;
	char backup;
	/*~PROTOBEG~ FIELD_CHECK_MULTI */
public:
	FIELD_CHECK_MULTI (const char *_prompt,
		 char &_var,
		 const char *_options[]);
	void dokey (WINDOW *dialog,
		 int key,
		 FIELD_MSG&);
	void drawtxt (WINDOW *dialog);
	char getidprefix (void);
	void gui_draw (int nof, int &);
	void gui_get (int nof);
	void html_draw (int nof);
	int html_validate (int nof);
	void reload (const char *dianame, int nof);
	void restore (void);
	void save (void);
	/*~PROTOEND~ FIELD_CHECK_MULTI */
};




class BUTTONS_INFO;

class DIALOG: public ARRAY{
	friend class DIALOG_LISTE;
protected:
	class DIALOG_INTERNAL *internal;
	/*~PROTOBEG~ DIALOG */
public:
	DIALOG (void);
protected:
	void add (FIELD *f);
public:
	void addhelp (HELP_FILE&help, const char *title);
	void addwhat (const char *help);
	void delwhat (const char *help);
private:
	void dokeydown (int &nof, WINDOW *dialog);
	void dokeyup (int &nof, WINDOW *dialog);
	void draw (WINDOW *dialog);
	void drawarrow_if (WINDOW *win,
		 bool condition,
		 bool&flag,
		 bool top,
		 chtype carac);
protected:
	void drawf (WINDOW *dialog);
public:
	MENU_STATUS edit (const char *_title,
		 const char *_intro,
		 HELP_FILE&helpfile,
		 int &nof,
		 int but_options);
	MENU_STATUS edit (const char *_title,
		 const char *intro,
		 HELP_FILE&helpfile);
	MENU_STATUS edit (const char *_title,
		 const char *intro,
		 HELP_FILE&helpfile,
		 int &nof);
private:
	MENU_STATUS editgui (int &nof, int but_options);
	MENU_STATUS editgui_thread (int &nof, int but_options);
	MENU_STATUS edithtml (int &nof);
public:
	virtual MENU_STATUS editmenu (const char *title,
		 const char *prompt,
		 HELP_FILE&helpfile,
		 int &sel,
		 int options);
private:
	MENU_STATUS editterm (int &nof, int but_options);
	void fixwidth1 (void);
public:
	FIELD *getitem (int no);
	const char *getmenustr (int choice);
	void gui_passthrough (int command,
		 const char *args,
		 ...);
	void gui_passthroughv (int command,
		 const char *args,
		 va_list list);
private:
	void guidelete (void);
public:
	void hide (void);
	void html_body (const char *ctl, ...);
private:
	void html_draw (DIALOG *spc, int nof);
	void html_draw (int nof);
	void html_draw_end (void);
	void html_draw_fields (int nof);
	void html_draw_form (int nof);
	void html_draw_intro (void);
	void html_draw_top (void);
public:
	void html_end (const char *ctl, ...);
	void html_intro (const char *ctl, ...);
	void html_top (const char *ctl, ...);
private:
	int html_validate (void);
public:
	void inswhat (const char *help);
protected:
	virtual int keymove (WINDOW *dialog,
		 int key,
		 int &nof);
public:
	void last_noempty (void);
	void new_menuinfo (const char *prompt1,
		 const char *prompt2);
	void new_menuitem (const SSTRING&prompt1,
		 const SSTRING&prompt2);
	void new_menuitem (const char *icon,
		 const char *prompt1,
		 const char *prompt2);
	void new_menuitem (const char *prompt1,
		 const SSTRING&prompt2);
	void new_menuitem (const char *prompt1,
		 const char *prompt2);
private:
	void new_menuitem_parse (const char *item1,
		 const char *item2);
public:
	void new_menuitems (const char *items[], int item_no);
	void new_menuitems (const char *opt[]);
	void new_menuline (const char *icon,
		 const char *prompt1,
		 const char *prompt2,
		 bool may_select);
	FIELD_CHECK *newf_chk (const char *prompt,
		 char &var,
		 const char *title);
	FIELD_CHECK_MULTI *newf_chkm (const char *prompt,
		 char &var,
		 const char *title[]);
	FIELD_CHECK_MULTI *newf_chkm_col (const char *prompt,
		 char &var,
		 const char *title[]);
	FIELD_CHECK_MULTI *newf_chkm_hexnum (const char *prompt,
		 int &var,
		 const int vals[],
		 const char *options[]);
	FIELD_CHECK_MULTI *newf_chkm_num (const char *prompt,
		 int &var,
		 const int vals[],
		 const char *options[]);
	FIELD_COMBO *newf_combo (const char *prompt,
		 SSTRING&str);
	FIELD_COMBO_MANY *newf_combo_many (const char *prompt,
		 SSTRING&str);
	FIELD *newf_dbl (const char *prompt,
		 double &val,
		 int nbdecimals);
	FIELD_ENUM *newf_enum (const char *prompt, int &sel);
	FIELD *newf_gauge (const char *prompt,
		 int &val,
		 int range);
	virtual void newf_head (const char *prompt,
		 const char *msg);
	FIELD *newf_hexnum (const char *prompt, int &val);
	void newf_info (const char *prompt, const char *str);
	FIELD_LIST *newf_list (const char *prompt,
		 SSTRING&str);
	FIELD *newf_num (const char *prompt, int &val);
	FIELD *newf_octnum (const char *prompt, int &val);
	FIELD_PASSWORD *newf_pass (const char *prompt,
		 SSTRING&str);
	FIELD_RADIO *newf_radio (const char *prompt,
		 char &var,
		 char instance_val,
		 const char *title);
	void newf_sheet (const char *prompt,
		 const char *titles[],
		 SSTRINGS&tb);
	FIELD *newf_slider (const char *prompt,
		 int &val,
		 int minval,
		 int maxval);
	FIELD_SSTRING *newf_str (const char *prompt,
		 SSTRING&str);
	FIELD_SSTRING *newf_str (const char *prompt,
		 SSTRING&str,
		 int width);
	FIELD_STRING *newf_str (const char *prompt,
		 char *str,
		 int maxsiz);
	void newf_textarea (const char *prompt,
		 SSTRING&text,
		 int width,
		 int height);
	void newf_title (const char *pad,
		 int level,
		 const char *prompt,
		 const char *msg);
	void newf_title (const char *prompt, const char *msg);
	void newline (void);
private:
	void processmsg (WINDOW *dialog, FIELD_MSG&msg);
public:
	void reload (int no);
	void reload (int start, int end);
	void reload (void);
	void remove_all (void);
	int remove_del (int no);
	void remove_last (int cut);
	void restore (void);
	void save (void);
	void savewhat (const char *help);
	void set_alt_title (const char *_title);
	void set_lastreadonly (void);
	void set_menuitem (int no,
		 const char *prompt1,
		 const char *prompt2);
	void set_readonly (void);
	void setbutinfo (int id,
		 const char *title,
		 const char *icon);
	void setcontext (const char *s);
private:
	const char *setguiname (char tmp[200]);
public:
	void setheight_hint (void);
	void seticon (const char *_icon);
private:
	void setoffset (int newoff);
public:
	void setsidetitle (const char *ctl, ...);
	void settype (DIALOG_TYPE type);
private:
	void setup (void);
public:
	void show (const char *_title,
		 const char *_intro,
		 HELP_FILE&helpfile,
		 int &nof,
		 int but_options);
private:
	void showgui (int &nof, int but_options);
	void showterm (int nof, int but_options);
	void showtimeout (WINDOW *win);
	void skipprotect (int &nof,
		 int suggestkey,
		 WINDOW *dialog);
public:
	void waitfor (const char *msg);
	int was_modified (void);
	~DIALOG (void);
	/*~PROTOEND~ DIALOG */
};

class DIALOG_RECORDS: public DIALOG{
	/*~PROTOBEG~ DIALOG_RECORDS */
public:
	DIALOG_RECORDS (void);
	MENU_STATUS editmenu (const char *title,
		 const char *prompt,
		 HELP_FILE&helpfile,
		 int &sel,
		 int options);
	void newf_head (const char *prompt,
		 const char *msg);
	void setkeyformat (HTML_KEY_TYPE key_type);
	/*~PROTOEND~ DIALOG_RECORDS */
};

class DIALOG_LISTE: public DIALOG_RECORDS{
	/*~PROTOBEG~ DIALOG_LISTE */
public:
	DIALOG_LISTE (void);
	MENU_STATUS editmenu (const char *title,
		 const char *prompt,
		 HELP_FILE&helpfile,
		 int &sel,
		 int options);
	~DIALOG_LISTE (void);
	/*~PROTOEND~ DIALOG_LISTE */
};

class DIALOG_MENU: public DIALOG{
	/*~PROTOBEG~ DIALOG_MENU */
public:
	virtual MENU_STATUS editmenu (const char *title,
		 const char *prompt,
		 HELP_FILE&helpfile,
		 int &sel,
		 int options);
	void setmenu (MENU_CONTEXT ctx);
	/*~PROTOEND~ DIALOG_MENU */
};

class  DIALOG_TEXTBOX: public DIALOG{
	/*~PROTOBEG~ DIALOG_TEXTBOX */
public:
	DIALOG_TEXTBOX (void);
protected:
	int keymove (WINDOW *dialog,
		 int key,
		 int &nof);
public:
	void newf_text (const char *,
		 const SSTRINGS&strs);
	void newf_text (const char *prompt,
		 const char *buftab);
	/*~PROTOEND~ DIALOG_TEXTBOX */
};


class HTML_VARVAL;
class POPENFD;

#include "dialog.p"

#endif
