#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <string.h>
#include <stdarg.h>
#include <pwd.h>
#include <unistd.h>
#include "diajava.h"
#include "diajava.m"
#include "../paths.h"
#include <dialog.h>

#define USE_JAVA	0

static bool dbg_com = false;

PUBLIC DIAJAVA::DIAJAVA(bool guiok)
{
	pop = NULL;
	if (getuid()==0 && getenv("DBG_COM")!=NULL) dbg_com = true;
	/* #Specification: remadmin / user id of the process
		We try to execute remadmin as the real user
		who started linuxconf. This has several advantages.
		One is that the user .Xdefaults is available.
		The other is that remadmin has access to the normal
		.Xauthority file and is allowed to connect to the
		X server even if access control is restrictive (xhost -)
	*/
	char pipestr[100],textstr[100];
	sprintf (pipestr,"--pipe %s",popen_SOCKETHOLDER);
	sprintf (textstr,"--text --pipe %s",popen_SOCKETHOLDER);
	pop = new POPEN ("remadmin"
		,guiok ? pipestr : textstr
		,popen_getloginuid());
	if (!pop->isok()){
		delete pop;
		pop = NULL;
	}else{
		setvbuf (pop->getfout(),NULL,_IOFBF,8192);
	}
}

/*
	When talking to the user interface server using a socket
	(this is happenning when connecting from a browser)
*/
PUBLIC DIAJAVA::DIAJAVA(int handlein, int handleout, const char *lines)
{
	pop = new POPENFD (handlein,handleout);
	pop->loadout (lines);
	setvbuf (pop->getfout(),NULL,_IOFBF,8192);
}

PUBLIC DIAJAVA::~DIAJAVA()
{
	delete pop;
}
/*
	Return != if the java user interface server is correctly started
*/
PUBLIC int DIAJAVA::is_ok()
{
	return pop != NULL;
}


PUBLIC ITEM_VAL::ITEM_VAL(
	const char *_diapath,	// Absolute path of the field dumping this
				// value
	const char *_id,	// ID of the field. This ID is generally
				// unique in a dialog, so the diapath
				// is not relevant, but used in some cases
				// especially for treemenu where the ID are
				// forged (so two treemenu in the same
				// dialog may reference the same ID)
	const char *_val)	// Value associated with the field
{
	diapath.setfrom (_diapath);
	id.setfrom (_id);
	val.setfrom (_val);
}

PUBLIC ITEM_VAL *ITEM_VALS::getitem(int no)
{
	return (ITEM_VAL*)ARRAY::getitem(no);
}

/*
	This function should return NULL if the ID is not found.
	But this should never happen.
*/
PUBLIC const char *ITEM_VALS::getval (
	const char *diapath,	// May be NULL if the ID is known to be
				// unique
	const char *id)
{
	const char *ret = "";
	int n = getnb();
	for (int i=0; i<n; i++){
		ITEM_VAL *v = getitem(i);
		if ((diapath == NULL || v->diapath.cmp(diapath)==0)
			&& v->id.cmp(id)==0){
			ret = v->val.get();
			break;
		}
	}
	return ret;
}

PUBLIC int ITEM_VALS::getvals (
	const char *diapath,
	const char *id,
	SSTRINGS &tb)
{
	int ret = 0;
	int n = getnb();
	tb.neverdelete();
	for (int i=0; i<n; i++){
		ITEM_VAL *v = getitem(i);
		if ((diapath == NULL || v->diapath.cmp(diapath)==0)
			&& v->id.cmp(id)==0){
			tb.add (&v->val);
			ret ++;
		}
	}
	return ret;
}


/*
	Return the value associated with "id"
	Return an empty string if there is none.
*/
PUBLIC const char *DIAJAVA::getval (const char *diapath, const char *id)
{
	return vals.getval (diapath,id);
}

/*
	Get all values associated with "id".
	Return the number of values found.
*/
PUBLIC int DIAJAVA::getvals (const char *diapath, const char *id, SSTRINGS &tb)
{
	return vals.getvals (diapath,id,tb);
}

bool diajava_treemenu=false;
bool diajava_reconfdia=false;	// The front-end accept redefinition
								// of an existing dialog
bool diajava_gauge=false;		// The front-end has a gauge widget
bool diajava_slider=false;		// The front-end has a slider widget
bool diajava_setval=false;		// The front-end support PROTO_Setval
bool diajava_alive=false;		// The front-end support PROTO_Alive
bool diajava_context=false;		// The front-end support the . addressing

static int lastmouse_state=0;

/*
	Get the state of the mouse and keyboard for the last selection
	made in a clist, menu or other UI objects
*/
void diajava_lastmousestate (UISTATE &state)
{
	state.leftb = (lastmouse_state & 1) != 0;
	state.middleb = (lastmouse_state & 2) != 0;
	state.rightb = (lastmouse_state & 4) != 0;
	state.ctrlkey = (lastmouse_state & 8) != 0;
	state.shiftkey = (lastmouse_state & 16) != 0;
	state.altkey = (lastmouse_state & 32) != 0;
	state.metakey = (lastmouse_state & 64) != 0;
}

PUBLIC int DIAJAVA::wait (
	POPENWAITS &tbpopen,
	char dianame[200],	// Name of the dialog where the event occured
	char actionid[100],	// Parameter associated with the event
	int &menu,		// Will contain the menu line selected or -1
	int &but)		// Will contain the button selected or -1
{
	int ret = -1;
	menu = but = -1;
	dianame[0] = actionid[0] = '\0';
	vals.remove_all();
	bool done = false;
	bool first = true;
	lastmouse_state=0;
	while (!done){
		if (!first){	// Let process the html body
			POPENWAIT w (*pop,10000000);
			tbpopen.add (&w);
			ret = tbpopen.wait();
			tbpopen.remove (&w);
			if (w.getretcode()==-1){
				fprintf (stderr,MSG_U(E_REMEXIT,"remadmin (GUI frontend) exiting abnormaly\n"));
				exit(-1);
			}
			if (tbpopen.hasdata() || ret == 0) break;
		}
		first = false;
		char buf[1000];
		int nb;
		while ((nb = pop->readout(buf,sizeof(buf)-1))!=-1){
			strip_end (buf);
			if (dbg_com) fprintf (stderr,"readout :%s:\n",buf);
			char verb[20];
			char *pt = str_copyword (verb,buf,sizeof(verb)-1);
			if (strcmp(verb,"action")==0){
				pt = str_copyword (dianame,pt,200-1);
				pt = str_copyword (actionid,pt,100-1);
				char statestr[100];
				str_copyword (statestr,pt,sizeof(statestr)-1);
				if (actionid[0] != '\0'){
					if (strcmp(actionid,"badver")==0){
						fprintf (stderr,MSG_U(E_REMVER
							,"Incompatible version of the GUI frontend\n"));
						exit(-1);
					}
					int no = atoi(actionid+1);
					if (actionid[0] == 'B'){
						but = no;
					}else if (actionid[0] == 'X'){
						but = 99;	// See ../dialog/buttons.cc
									// BUTTONS_INFO::bid2status
									// turn this into MENU_ESCAPE
					}else if (actionid[0] == 'M'){
						menu = no;
						lastmouse_state = atoi(statestr);
					}
					done = true;
				}
			}else if (strcmp(verb,"dump")==0){
				char id[100],diapath[200];
				pt = str_copyword (diapath,pt,200-1);
				pt = str_copyword (id,pt,sizeof(id)-1);
				if (id[0] != '\0'){
					vals.add (new ITEM_VAL(diapath,id,pt+1));
				}
			}else if (strcmp(verb,"prefer")==0){
				while (1){
					char pref[100];
					pt = str_copyword (pref,pt,sizeof(pref)-1);
					if (pref[0] == '\0') break;
					if (strcmp(pref,"html")==0){
						diagui_sethtmlhelp();
					}else if (strcmp(pref,"nogfx")==0){
						menubox_setnogfx();
					}else if (strcmp(pref,"modal")==0){
						uithread_setmodal();
					}else if (strcmp(pref,"treemenu")==0){
						diajava_treemenu = true;
					}else if (strcmp(pref,"reconfdia")==0){
						diajava_reconfdia = true;
					}else if (strcmp(pref,"gauge")==0){
						diajava_gauge = true;
					}else if (strcmp(pref,"slider")==0){
						diajava_slider = true;
					}else if (strcmp(pref,"setval")==0){
						diajava_setval = true;
					}else if (strcmp(pref,"alive")==0){
						diajava_alive = true;
					}else if (strcmp(pref,"context")==0){
						diajava_context = true;
					}
				}				
				done = true;
				strcpy (actionid,"prefer");
				break;
			}else if (strcmp(verb,"gethtml")==0){
				char path[PATH_MAX];
				str_copyword (path,pt,PATH_MAX-1);
				diagui_sendhtmlhelp (path);
			}else if (strcmp(verb,"ncurses")==0){
				done = true;
				strcpy (actionid,"ncurses");
				// No front-end, treemenu can deal with the ncurse interface
				diajava_treemenu = true;
				break;
			}else{
				fprintf (stderr,"err :%s:\n",buf);
			}
		}
		while ((nb = pop->readerr(buf,sizeof(buf)-1)) != -1){
			fprintf (stderr,MSG_U(E_REMERR,"Error message from remadmin :%s"),buf);
		}
	}
	return ret;
}

PUBLIC void DIAJAVA::send (const char *ctl, ...)
{
	char buf[1000];
	va_list list;
	va_start (list,ctl);
	vsnprintf (buf,sizeof(buf)-1,ctl,list);
	pop->send (buf);
	va_end (list);
}

PUBLIC void DIAJAVA::sendcmd (int cmd, const char *ctl, ...)
{
	char buf[1000];
	int n = sprintf (buf,"%d ",cmd);
	va_list list;
	va_start (list,ctl);
	vsprintf (buf+n,ctl,list);
	pop->send (buf);
	va_end (list);
}
/*
	Flush the output buffer
*/
PUBLIC void DIAJAVA::flush ()
{
	pop->flush();
}

