#pragma interface
#ifndef COMPONENTS_H
#define COMPONENTS_H

/*
	A COMPONENT hold thoses informations
		A manufacturer ID
		A product model ID
		A pointer to a part of a Xconfig applicable to this component.
		A pointer to a notice
		A pointer to an action script
*/
#ifndef SECTION_H
	#include "section.h"
#endif
class NOTICE{
	char **tbstr;
	int nbstr;
	int maxstr;
	/*~PROTOBEG~ NOTICE */
public:
	NOTICE (void);
	void add (const char *str);
	int format (char *buf, int maxsiz)const;
	int print (FILE *fout, int indent)const;
	~NOTICE (void);
	/*~PROTOEND~ NOTICE */
};
class ACTION: public NOTICE{
	/*~PROTOBEG~ ACTION */
	/*~PROTOEND~ ACTION */
};
class COMPONENT: public PAIRES{
public:
	XCONFIG *xconfig;
	NOTICE *notice;
	ACTION *action;
	/*~PROTOBEG~ COMPONENT */
public:
	COMPONENT (const char *manuf_id,
		 const char *model_id,
		 XCONFIG *_xconfig,
		 NOTICE *_notice,
		 ACTION *_action);
	/*~PROTOEND~ COMPONENT */
};

#include <stdio.h>

class COMPONENTS{
	XCONFIG **tb_xconfig;
	int nb_xconfig;
	int max_xconfig;
	NOTICE **tb_notice;
	int nb_notice;
	int max_notice;
	ACTION **tb_action;
	int nb_action;
	int max_action;
	COMPONENT **tb_component;
	int nb_component;
	int max_component;
	/*~PROTOBEG~ COMPONENTS */
public:
	COMPONENTS (void);
	void add (COMPONENT *comp);
	void add (NOTICE *notice);
	void add (XCONFIG *xconf);
	COMPONENT *item (int no);
	void print (FILE *fout);
	int read (const char *fname);
	int setmenu (char *tbopt2[]);
	void sort (void);
	virtual ~COMPONENTS (void);
	/*~PROTOEND~ COMPONENTS */
};

#endif
