#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <misc.h>
#include <popen.h>
#include <netconf.h>
#include <daemoni.h>
#include "netconf.m"
#include "internal.h"

static NETCONF_HELP_FILE help_dnsconnect ("connect");

/*
	Do some test to see if the DNS is reachable or alive.
	Return -1 if any error.

	This function should be used at configuration time
	to avoid long timeout when no DNS is available.
*/
int dns_ping ()
{
	int ret = 0;
	if (dnsconf_isrslconf()){
		if (dns_getserial("0.0.127.in-addr.arpa","",4)==-1) ret = -1;
		net_prtlog (NETLOG_VERB,"%s: %s\n"
			,MSG_U(N_CHECKING,"Checking dns connectivity")
			,ret==-1 ? MSG_U(N_NOTGOOD,"Not good") : MSG_U(N_GOOD,"Ok"));
		/* #Specification: dnsconf / dnsping / connectivity problem
			linuxconf probe the DNS for proper setup. It does this by
			sending a SOA request to the DNS with a timeout of 4 seconds.
			If the request does not succeed, linuxconf print message
			and ask the user if he wish to continue the network
			operation he is doing (booting maybe). Unless he specify
			NO, the operation will continue. This means that an
			unattended boot will continue anyway even if the DNS is not
			working properly. This won't be good but should make the
			machine into some workable state.
		*/
		if (ret == -1){
			char errbuf[1000];
			sprintf (errbuf,MSG_U(E_DNSPROBLEM
					,"The DNS does not answer within %d seconds\n"
					 "This is bad and will cause major problems later\n"
					 "Do you want to continue ?\n"
					 "\n"
					 "(Note that this may indicate one minor DNS problem\n"
					 " please consult the help screen for further info)"),4);
			MENU_STATUS code = xconf_yesno (
				MSG_U(E_DNSCONNECT,"DNS connectivity")
				,errbuf
				,help_dnsconnect);
			if (code == MENU_YES
				|| (code == MENU_ESCAPE && dialog_mode != DIALOG_HTML)){
				ret = 0;
			}
		}
	}
	return ret;
}

/*
	Get the serial number of a domain
*/
long dns_getserial (const char *domain, const char *server, int timeout)
{
	long ret = -1;
	DAEMON_INTERNAL *dae = daemon_find ("nslookup");
	if (dae != NULL && dae->is_managed()){
		char buf[500];
		sprintf (buf,"%s -q=soa %s %s 2>/dev/null",dae->getpath()
			,domain,server);
		POPEN p(buf);
		while (ret == -1 && p.isok()){
			if (p.wait(timeout)<=0) break;
			while (p.readout(buf,sizeof(buf)-1)!=-1){
				char *pt = strstr(buf,"serial = ");
				if (pt != NULL){
					pt = str_skip (pt+9);
					ret = atol(pt);
					break;
				}
			}
		}
	}
	return ret;
}

