#include <stdio.h>
#include <string.h>
#include <dialog.h>
#include "uucp.h"
#include "uucp.m"

MODULE_DEFINE_VERSION(uucp);

PUBLIC MODULE_UUCP::MODULE_UUCP()
	: LINUXCONF_MODULE("uucp")
{
	linuxconf_loadmsg ("uucp",PACKAGE_REV);
}
static const char *keymenu=NULL;

PUBLIC void MODULE_UUCP::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_UUCP,"UUCP (Unix to unix copy)");
		dia.new_menuitem ("uucp","",keymenu);
	}
}

PUBLIC int MODULE_UUCP::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
			uucp_edit();
		}
	}
	return 0;
}

PUBLIC int MODULE_UUCP::execmain (int argc , char *argv[])
{
	int ret = -1000;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"uucpconf")==0){
		ret = uucp_main (argc, argv);
	}
	return ret;
}


static MODULE_UUCP uucp;



