#include <string.h>
#include "managerpm.h"
#include "managerpm.m"

static HELP_FILE help_browse ("managerpm","browse");

/*
	Let the user select many packages in a list (to do something with them later)
*/
static void browse_select(
	PACKAGES &pkgs,
	bool doinstall)
{
	DIALOG dia;
	for (int i=0; i<pkgs.getnb(); i++){
		PACKAGE *p = pkgs.getitem(i);
		dia.newf_chk ("",p->selected,p->name.get());
	}
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (
			doinstall ? MSG_U(T_PKGSINST,"Packages to install")
					  : MSG_U(T_PKGSUNINST,"Packages to uninstall")
			,doinstall ? MSG_U(I_PKGSINST
				,"Select the packages you want to install")
					  : MSG_U(I_PKGSUNINST
				,"Select the packages you want to un-install")
			,help_nil,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			dia.restore();
			break;
		}else{
			break;
		}
	}				
}



static void browse_packages (
	PACKAGES &pkgs,
	const char *group,
	bool doinstall)
{
	int n = pkgs.getnb();
	int lookup[n];
	pkgs.sort();
	DIALOG_RECORDS dia;
	dia.newf_head ("",MSG_U(H_NAMEVER,"Name\tVersion\tSummary"));
	PACKAGES tmppkgs;
	tmppkgs.neverdelete();
	for (int i=0; i<n; i++){
		PACKAGE *p = pkgs.getitem(i);
		if (p->group.cmp(group)==0){
			tmppkgs.add (p);
			lookup[dia.getnb()-1] = i;
			char ver[100];
			snprintf (ver,sizeof(ver)-1,"%s-%s\t%s",p->version.get()
				,p->release.get(),p->summary.get());
			dia.new_menuitem (p->name.get(),ver);
		}
	}
	dia.setbutinfo (MENU_USR1,MSG_U(B_SELECT,"Select"),MSG_R(B_SELECT));
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_PACKAGES,"Packages")
			,""
			,help_browse
			,nof,MENUBUT_USR1);
		if (code == MENU_QUIT || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_USR1){
			browse_select(tmppkgs,doinstall);
		}else{
			PACKAGE *p = pkgs.getitem(lookup[nof]);
			p->showinfo();
		}
	}
}


void browse_groups (
	PACKAGES &pkgs,
	bool doinstall)
{
	SSTRINGS groups;
	groups.neverdelete();
	int n = pkgs.getnb();
	for (int i=0; i<n; i++){
		PACKAGE *p = pkgs.getitem (i);
		groups.add (&p->group);
	}
	groups.sort();
	groups.remove_dups();
	DIALOG_RECORDS dia;
	dia.newf_head ("",MSG_U(H_GROUPS,"Package groups"));
	for (int i=0; i<groups.getnb(); i++){
		dia.new_menuitem (groups.getitem(i)->get(),"");
	}
	dia.setbutinfo (MENU_USR1,MSG_R(B_SELECT),MSG_R(B_SELECT));
	int butmask = MENUBUT_USR1;
	if (doinstall){
		dia.setbutinfo (MENU_USR2,MSG_R(B_INSTALL),MSG_R(B_INSTALL));
		butmask |= MENUBUT_USR2;
	}else{
		dia.setbutinfo (MENU_USR3,MSG_R(B_UNINSTALL),MSG_R(B_UNINSTALL));
		butmask |= MENUBUT_USR3;
	}
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.editmenu (MSG_U(T_GROUPS,"Package categories")
			,MSG_U(I_GROUPS
				,"Here is the list of package categories.\n"
				 "Pick one to see the associated packages")
			,help_browse
			,nof,butmask);
		if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else if (code == MENU_USR1){
			browse_select(pkgs,doinstall);
		}else if (code == MENU_USR2){
			pkgs.install();
		}else if (code == MENU_USR3){
			pkgs.uninstall();
		}else if (nof >=0 && nof < groups.getnb()){
			browse_packages(pkgs,groups.getitem(nof)->get(),doinstall);
		}
	}
}


/*
	Browse, by group the various installed packages
*/
void browse_installed()
{
	DIALOG dia;
	SSTRING wild;
	dia.newf_str (MSG_R(F_PATTERN),wild);
	int nof = 0;
	if (dia.edit (MSG_U(T_INSTALLEDPKGS,"Installed packages")
		,MSG_U(I_INSTPKGS,"Enter a file pattern to select some\n"
			"or all installed packages. The pattern is optional")
		,help_browse
		,nof)==MENU_ACCEPT){
		PACKAGES pkgs,sels;
		pkgs.loadinstall();
		pkgs.select (wild.get(),sels);
		browse_groups (sels,false);
	}
}

/*
	Browse, by group the various uninstalled packages of a directory
*/
void browse_uninstalled()
{
	DIALOG dia;
	SSTRING dir;
	mngrpm_setdirfield(dia,dir);
	SSTRING wild;
	wild.setfrom ("*.rpm");
	dia.newf_str (MSG_R(F_PATTERN),wild);
	int nof = 0;
	SSTRING mpoint;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_SOURCE,"Package source")
			,MSG_U(I_SOURCE
				,"Indicate where do you want to pick\n"
				 "the new packages")
			,help_browse
			,nof);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (mngrpm_ismounted(dir.get(),mpoint)){
			PACKAGES install;
			install.loadinstall();
			PACKAGES unins;
			unins.loadfromdir (dir.get(),wild.get());
			// Eliminate the one already installed
			int n = install.getnb();
			for (int i=0; i<n; i++){
				PACKAGE *in = install.getitem(i);
				PACKAGE *p = unins.locate (in->name.get());
				if (p != NULL) unins.remove_del (p);
			}
			browse_groups (unins,true);
			break;
		}
	}
	mngrpm_unmountif(mpoint);
}

