#pragma interface
#include <fviews.h>

class INETDCONFLIST;
class INETDCONF: public ARRAY_OBJ {
private:
	void init (void);
	void modify_service( VIEWITEM *item );
	int input_error( void );
public:
	SSTRING service_name;	// 
	SSTRING socket_type;	// 
	SSTRING protocol;	//
	char multi;		// wait=1, no wait=0
	int max;		// Max starts per minute
	SSTRING user;		//
	SSTRING group;		//
	SSTRING path;		//
	SSTRING arguments;	//
	char enabled;		// Service enabled = 1
	int new_inetdconf;	// Old=0, new=1
	int inetdconf_line;	// Line number in file /etc/inetd.conf
	int port;		// Port from /etc/services
	/*~PROTOBEG~ INETDCONF */
public:
	INETDCONF (const char *_service_name);
	INETDCONF ( void );
	int edit (void);
	int edit ( INETDCONFLIST *inetdconflist);
	int write ( int button );
public:
	/*~PROTOEND~ INETDCONF */
	void present( char *buf1, int size1, char *buf2, int size2);
};

class INETDCONFLIST: public ARRAY {
private:
	char *next_word( char *d, char *s, int size );
	void add_service( int line, VIEWITEM *item );
	int valid_etcservice( char *word, INETDCONF *inetdconf );
	int valid_socket_type( char *word, INETDCONF *inetdconf );
	int valid_protocol( char *word, INETDCONF *inetdconf );
	int valid_multi_max( char *word, INETDCONF *inetdconf );
	int valid_user_group( char *word, INETDCONF *inetdconf );
	int valid_path( char *word, INETDCONF *inetdconf );
	/*~PROTOBEG~ INETDCONFLIST */
public:
	INETDCONFLIST( );
	int edit (void);
	INETDCONF *getitem (const char *id) const;
	INETDCONF *getitem (int negative) const;
	void read (void);
	void sort ( void );
	/*~PROTOEND~ INETDCONFLIST */
};

