#pragma implementation
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>
#include <misc.h>
#include <configf.h>
#include <usercomng.h>
#include <userconf.h>
#include <translat.h>
#include <fviews.h>
#include "fetchmailconf.h"
#include "fetchmailconf.m"
#include "serveredit.h"
#include "useridedit.h"
#include "comng.h"

/*
 * Co-manager user class
 */
static HELP_FILE help_fetchmailcomng( "fetchmailconf", "usercomng" );

static PRIVILEGE p_userid ("fetchmailconf_comng"
    ,P_MSG_U(T_PRIVUSERSFETCHMAIL,"Users/Fetchmail")
    ,P_MSG_R(T_PRIVILEGE));


PUBLIC FETCHMAIL_COMNG::FETCHMAIL_COMNG( DICTIONARY &_dict )
	: USERACCT_COMNG( _dict )
{
//fprintf( stderr, "comng.cc: FETCHMAIL_COMNG::FETCHMAIL_COMNG()\n");
	is_new = dict.get_bool( "is_new" );
	local_user = dict.get_str( "name" );
	serverlist.read();
}


PUBLIC void FETCHMAIL_COMNG::setupdia( DIALOG &dia )
{
//fprintf( stderr, "comng.cc: FETCHMAIL_COMNG::setupdia: local_user=%s %s\n", local_user.get(), is_new?"is_new":"");
	if ( serverlist.getnb() == 0 ) {
		return;
	}
	if ( ! perm_checkpriv( &p_userid ) ) {
		return;
	}
	dia.addhelp( help_fetchmailcomng,MSG_U(T_FETCHMAIL_COMNG,"Fetch mail"));
	dia.newf_title( MSG_R(T_FETCHMAIL_COMNG),1,"",MSG_R(T_FETCHMAIL_COMNG));

	for (int i=0; i<serverlist.getnb(); i++) {
		SERVER *server = serverlist.getitem(i);
		const char *server_name = server->server_name.get();

//fprintf( stderr, "comng.cc: server_name=%s\n",server_name);
		dia.newf_title( server_name, 2, "", server_name );
		useridlist.remove_all();
		useridlist.read( server );
		USERID *new_userid;
		USERID *userid;
		if ( is_new ) {
			userid = NULL;
		} else {
			userid = useridlist.getitem( local_user.get() );
		}
		if ( userid == NULL ) {
			new_userid = new USERID( );
			new_userid->local_user.setfrom( local_user );
			new_userid->new_userid = true;
//fprintf( stderr, "comng.cc: NEW: server_name=%s local_user=%s\n",server_name, new_userid->local_user.get());
		} else {
			new_userid = new USERID( );
			new_userid->local_user.setfrom( local_user );
			new_userid->remote_user.setfrom( userid->remote_user );
			new_userid->old_remote_user.setfrom( userid->remote_user );
			new_userid->password.setfrom( userid->password );
			new_userid->new_userid = false;
		}
		new_userid->server = server;
		new_useridlist.add( new_userid );
		dia.newf_str(MSG_R(F_REMOTEUSER), new_userid->remote_user );
		dia.newf_str(MSG_R(F_USERPASSWORD), new_userid->password );
	}
}

PUBLIC int FETCHMAIL_COMNG::validate( DIALOG &dia, int &nof )
{
//fprintf( stderr, "comng.cc: FETCHMAIL_COMNG::validate\n");
	if ( serverlist.getnb() == 0 ) {
		return( 0 );
	}
	if ( ! perm_checkpriv( &p_userid ) ) {
		return( 0 );
	}
	// -1 at error
	return( 0 );
}

PUBLIC int FETCHMAIL_COMNG::save( PRIVILEGE *privilege )
{
//fprintf( stderr, "comng.cc: FETCHMAIL_COMNG::save\n");
	if ( serverlist.getnb() == 0 ) {
		return( 0 );
	}
	if ( ! perm_checkpriv( &p_userid ) ) {
		return( 0 );
	}
	if ( is_new ) {
		local_user = dict.get_str( "name" );
		if ( local_user.is_empty() ) {
			return( 0 );
		}
//fprintf( stderr, "comng.cc: FETCHMAIL_COMNG::save: local_user=%s\n", local_user.get());
	}
	SERVER *server = NULL;
	USERID *userid = NULL;
	for ( int s=0; s< serverlist.getnb(); s++ ) {
		server = serverlist.getitem( s );
		userid = new_useridlist.getitem( s );
		if ( userid == NULL ) {
			continue;
		}
		if ( is_new ) {
			userid->new_userid = true;
			userid->local_user.setfrom( local_user );
		}
//fprintf( stderr, "server->server_name=%s userid->remote_user=%s userid->password=%s userid->local_user=%s %s\n", server->server_name.get(), userid->remote_user.get(), userid->password.get(), userid->local_user.get(),  userid->new_userid?"new_userid":"old_userid");
		if (( userid->remote_user.is_empty() )
		&& ( ! userid->old_remote_user.is_empty() )) {
			userid->remote_user.setfrom( userid->old_remote_user );
			userid->write( MENU_DEL );
		} else {
			if (( ! userid->remote_user.is_empty() )
			&& (  ! userid->password.is_empty() )) {
				userid->write( MENU_ACCEPT );
			}
		}
	}
	return( 0 );
}

PUBLIC int FETCHMAIL_COMNG::deluser( PRIVILEGE *privilege )
{
//fprintf( stderr, "comng.cc: FETCHMAIL_COMNG::deluser\n");
	SERVER *server = NULL;
	USERID *userid = NULL;
	for ( int s=0; s< serverlist.getnb(); s++ ) {
		server = serverlist.getitem( s );
		userid = new_useridlist.getitem( s );
//fprintf( stderr, "server->server_name=%s userid->remote_user=%s userid->password=%s %s\n",server->server_name.get(), userid->remote_user.get(), userid->password.get(), userid->new_userid?"new_userid":"old_userid");
		userid->write( MENU_DEL );
	}
	return( 0 );
}
