#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#include <stdio.h>
#ifndef MISC_H
	#include "misc.h"
#endif

#ifndef DNSCONF_H
	#include "dnsconf.h"
#endif
#include <time.h>

struct PRIMARY_EDITINFO {
	SSTRINGS rns;
	SSTRINGS rmx;
	IP_ADDRS  tba;
	RECORD_IN_SOA *soa;
	int start_mx;
	int start_ns;
};

class DNSCONF_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ DNSCONF_HELP_FILE */
public:
	DNSCONF_HELP_FILE (const char *fname);
	/*~PROTOEND~ DNSCONF_HELP_FILE */
};

struct RECORD_PARSE{
	long ttl;
	bool nottl;
	char f1[200];
	char f2[200];
	char f3[200];
	char f4[200];
	char f5[200];
	char f6[200];
	char f7[200];
	char f8[200];
	/*~PROTOBEG~ RECORD_PARSE */
public:
	RECORD_PARSE (void);
	/*~PROTOEND~ RECORD_PARSE */
};


// Manage a bunch of open file (open recursivly)
class TBFILE{
	bool extract;
	char *defpath;
	int nbopen;
	FILE *tb[10];	// Maximum 10 level of include file
public:
	FILE *cur;	// Current open file
	/*~PROTOBEG~ TBFILE */
public:
	TBFILE (const char *_defpath, bool _extract);
	void fclose (void);
	FILE *fopen (const char *fname, const char *mode);
	~TBFILE (void);
	/*~PROTOEND~ TBFILE */
};


class RECORD_IN_CNAME: public RECORD_IN{
public:
	IN_NAME nickname;
	IN_NAME name;
	/*~PROTOBEG~ RECORD_IN_CNAME */
public:
	RECORD_IN_CNAME (const RECORD_PARSE&p);
	RECORD_IN_CNAME (const char *cname,
		 const char *realname);
	int cmp_left (const char *str);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE *fout)const;
	void sethostpart (const char *hostpart);
	/*~PROTOEND~ RECORD_IN_CNAME */
};
class RECORD_IN_SOA: public RECORD_IN{
public:
	SSTRING domain;
	SSTRING machine;
	SSTRING admin;
	long old_serial;
	long new_serial;
	TIMESTR refresh;
	TIMESTR retry;
	TIMESTR expire;
	TIMESTR default_ttl;
	time_t lastrequest;		// Last time we request the serial number
							// of the zone, see soa.cc
	/*~PROTOBEG~ RECORD_IN_SOA */
public:
	RECORD_IN_SOA (const RECORD_PARSE&p);
	RECORD_IN_SOA (void);
	void print (FILE *fout)const;
	void update (const char *name);
	/*~PROTOEND~ RECORD_IN_SOA */
};

class RECORD_IN_NS: public RECORD_IN{
public:
	IN_NAME name;
	IN_NAME ns;
	/*~PROTOBEG~ RECORD_IN_NS */
public:
	RECORD_IN_NS (const RECORD_PARSE&p);
	RECORD_IN_NS (const char *_name, const char *_ns);
	RECORD_IN_NS (void);
	int cmp_left (const char *str);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE *fout)const;
	int set (const RECORD *other);
	void sethostpart (const char *hostpart);
	/*~PROTOEND~ RECORD_IN_NS */
};
class RECORD_IN_MX: public RECORD_IN{
public:
	IN_NAME mailname;
	IN_NAME servname;
	int prefer;
	/*~PROTOBEG~ RECORD_IN_MX */
public:
	RECORD_IN_MX (const RECORD_PARSE&p);
	RECORD_IN_MX (const char *_mailname,
		 int priority,
		 const char *_servname);
	int cmp_left (const char *str);
protected:
	int cmpsame (const RECORD *other);
public:
	void print (FILE *fout)const;
	int set (const RECORD *other);
	void sethostpart (const char *hostpart);
	/*~PROTOEND~ RECORD_IN_MX */
};

class RECORD_INCLUDE: public RECORD{
public:
	SSTRING path;
	/*~PROTOBEG~ RECORD_INCLUDE */
public:
	RECORD_INCLUDE (const char *_path);
	void print (FILE *fout)const;
	/*~PROTOEND~ RECORD_INCLUDE */
};
// A simple marker for telling the system where the include stops in the
// list. All record are stored in a single list even if they comes from
// include files.
class RECORD_END_INCLUDE: public RECORD{
	/*~PROTOBEG~ RECORD_END_INCLUDE */
public:
	RECORD_END_INCLUDE (void);
	void print (FILE *)const;
	/*~PROTOEND~ RECORD_END_INCLUDE */
};

struct FQHOST_DECOMP{
	char host[100];
	char domain[100];
};

class FQHOST{
public:
	int nbelm;	// Number of variation possible.
			// To speed up manipulation
	FQHOST_DECOMP tb[10];
	/*~PROTOBEG~ FQHOST */
public:
	FQHOST (const SSTRING&host);
	FQHOST (const char *host);
	FQHOST (const char *host, const char *domain);
	void formatfull (SSTRING&full);
	void formatfull (char *full);
	const char *gethostpart (const char *domain);
private:
	void init (const char *host);
public:
	int is_member (const char *domain, char *hostpart);
	int is_reverse (void);
	/*~PROTOEND~ FQHOST */
};

class IPMAPS: public ARRAY{
	/*~PROTOBEG~ IPMAPS */
public:
	IPMAPS (void);
	int allocateip (const char *range,
		 char *ip,
		 DNS&dns);
	int edit (void);
	IPMAP *getitem (int no);
private:
	void newdiaf (DIALOG&dia, IPMAP *e);
public:
	void setcombo (class FIELD_COMBO *comb);
	void setuse (IP_ADDRS&adrs);
	int write (void);
	/*~PROTOEND~ IPMAPS */
};

struct BIND8_FILE{
	FILE *fin;
	int noline;
	SSTRING path;
};


class BIND8_LEXPARSE{
	CONFIG_FILE &cfg;
	BIND8_FILE tbf[5];		// Up to 4 include files
	int nofile;
	char buf[1000];
	char token[1000];
	char *ptbuf;
	SSTRING comment;
	bool err;
	SSTRING *dir;		// Directory for include files
	/*~PROTOBEG~ BIND8_LEXPARSE */
public:
	BIND8_LEXPARSE (CONFIG_FILE&_cfg,
		 SSTRING&_dir);
	void error (const char *ctl, ...);
	int expect (const char *s);
private:
	int fillbuf (void);
public:
	const char *getarg1 (void);
	bool getarg_yesno (void);
	const char *getcomment (void);
	const char *gettoken (bool keepquote);
	const char *gettoken (void);
	bool isok (void);
	bool waserr (void);
	~BIND8_LEXPARSE (void);
	/*~PROTOEND~ BIND8_LEXPARSE */
};


extern const char subsys_dnsserv[];

#endif

