#pragma interface
#ifndef DIALPPP_H
#define DIALPPP_H

#define TYPE_PPP_SERIAL	0
#define TYPE_PPP_PAP	1	// Those two (PAP and CHAP) are not used
#define TYPE_PPP_CHAP	2	// anymore. They are differentiate from
							// standard PPP using the PPP_AUTH defines
							// For compatibility, the old definition
							// are translated when read
#define TYPE_SLIP		3
#define TYPE_PLIP1		4
#define TYPE_PLIP2		5
#define TYPE_PPP_SSH	6

#define PPP_AUTH_LOGIN	0
#define PPP_AUTH_PAP	1
#define PPP_AUTH_CHAP	2
#define PPP_AUTH_NONE	3

#define PPP_USE_MANUAL	0		// Connect manually (triggered by user)
#define PPP_USE_DEMAND	1		// Connect using diald
#define PPP_USE_24on24	2		// Dedicated link

struct LK_STR{
	const char *key;
	SSTRING *str;
	const char *defval;
};
struct LK_INT{
	const char *key;
	int *num;
	int defval;
};
struct LK_CHAR{
	const char *key;
	char *num;
	char defval;
};

class PPPIPROUTE: public ARRAY_OBJ{
public:
	SSTRING dest;
	SSTRING mask;
	/*~PROTOBEG~ PPPIPROUTE */
public:
	PPPIPROUTE (const char *s);
	PPPIPROUTE (void);
	/*~PROTOEND~ PPPIPROUTE */
};

class PPPIPROUTES: public ARRAY{
	/*~PROTOBEG~ PPPIPROUTES */
public:
	int empty (void);
	PPPIPROUTE *getitem (int no);
	/*~PROTOEND~ PPPIPROUTES */
};

class PROC;

class PPPONE{
public:
	bool exist;			// The configuration exist (is not new)
	CONFIG_FILE *cfile;
	CONFDB *cfg;
	SSTRING name;		// Symbolic name of the configuration
	SSTRING phone;
	SSTRING login;
	SSTRING passwd;
	SSTRING loginkey;	// String required before sending login
						// Normally ogin:
	SSTRING passwdkey;	// String required before sending the password
						// Normally assword:
	SSTRING loginok;	// optionnal confirmation string
						// telling the passwd was good
	SSTRING trigger;	// optionnal command we must send when connecting
						// to the ISP. Used for shell account generally.
	SSTRING loginfail;	// optionnal string identifying a login failure
						// (password was wrong)
	SSTRING loginchat;	// Custom login chat in case the standard one
						// fail.
	SSTRING device;
	SSTRING modeminit;
	char type;	// TYPE_xxxx
	char defaultroute;
	char modem;	// Modem controls
	char lock;	// Set standard lock file
	char proxyarp;	// Establish proxyarp when connecting
	char pppauth;	// Type of PPP authentication
	char usetype;	// PPP_USE_xxxxx
	char persist;
	int mru;
	int mtu;
	int baud;
	int idletime;
	char dbgppp;
	char dbgchat;
	char firewall;
	SSTRING options;	// pppd options which are not
				// handled by this program
	SSTRING asyncmap;	// One specific important option of
				// pppd
	SSTRING ourip;		// Optionnal IP numbers
	SSTRING remoteip;
	SSTRING lcpecho;
	SSTRING chatscript;
	LK_STR strs[30];
	LK_INT nums[20];
	LK_CHAR chars[20];
	struct {
		SSTRING host;
		SSTRING user;
		SSTRING encrypt;
		SSTRING pppd_path;
		char compress;
		char via_shell;
		char use_patch;
	}ssh;
	PPPIPROUTES iproutes;
	SSTRING preconcmd;
	SSTRING postconcmd;
	SSTRING postdiscmd;
	SSTRING prediscmd;
	struct {
		char enable;
		int netnum;
		int localnum;
		int remotenum;
		char routingrip;
		char routingnlsp;
		SSTRING options;
	}ipx;
	/*~PROTOBEG~ PPPONE */
public:
	PPPONE (const char *_name);
	int connect (bool fore);
	int connect_diald (void);
private:
	int connect_plip (void);
	int connect_ppp (bool fore, PRIVILEGE *priv);
	int connect_pppssh (int);
	int connect_slip (int);
protected:
	void del (const char *_name);
public:
	void delpidfile (void);
	void dialdcleanup (void);
	int disconnect (void);
	int disconnect_diald (void);
private:
	int disconnect_plip (void);
	int disconnect_ppp (void);
	int disconnect_slip (void);
public:
	int edit (void);
	PROC *getdialdproc (void);
	int getpppd_info (char pppdev[8]);
	int getpppd_pid (void);
	int getusetype (void);
	int killdiald (void);
private:
	int lcpecho_parse (int &delay, int &retry);
	int lcpecho_valid (void);
	void opencfg (void);
public:
	int postconnect (const char *dev);
private:
	int pppwait_cmd (const char *cmd);
public:
	int predisconnect (const char *);
	int save (void);
private:
	void setdia_iproute (DIALOG&dia, int no);
public:
	void setdialdconfpath (char *diapath);
	void setdialdpidpath (char *pidpath);
	void setfifopath (char *diapath);
private:
	void setfifowait (char *path);
	void setipparam (char *str);
	void setipxparam (char *str);
	void setpapchap (char *pppopt, PRIVILEGE *priv);
	int setpppchat (char *pathchat_sh);
public:
	int setroutes (const char *cmd_suffix);
	int setupdiald (int id);
private:
	void setupdiald (int id, SSTRING&setup);
	void setuptbdb (void);
public:
	int startdiald (int id);
private:
	int updsecrets (PRIVILEGE *priv);
	int validate_edit (SSTRING&baudstr, SSTRING&oldname);
public:
	~PPPONE (void);
	/*~PROTOEND~ PPPONE */
};

#if 0

class PPPONES: public ARRAY{
	/*~PROTOBEG~ PPPONES */
	/*~PROTOEND~ PPPONES */
};
#endif

extern const char PPP_CHANNEL[];
extern const char linuxconf_dialout[];
extern const char linuxconf_dialin[];
extern const char ppp_dialout[];
extern int (*ppphook_status)(const char *, char [20]);
extern int (*ppphook_control)(const char *, bool);


#endif
