#pragma interface
#ifndef MODAPI_H
#define MODAPI_H
// Make sure dialog.h can't be include as well
#define DIALOG_H
#ifndef DIALOG_DEF_H
	#include <dialog_def.h>
#endif

class M_DIALOG_OBJECT{
public:
	M_DIALOG_OBJECT *next;
	/*~PROTOBEG~ M_DIALOG_OBJECT */
	/*~PROTOEND~ M_DIALOG_OBJECT */
};


class M_FIELD_COMBO: public M_DIALOG_OBJECT{
public:
	class FIELD_COMBO *real;
	/*~PROTOBEG~ M_FIELD_COMBO */
public:
	M_FIELD_COMBO (FIELD_COMBO *_real,
		 M_FIELD_COMBO *first);
	void addopt (const char *str);
	void addopt (const char *value,
		 const char *verbose);
	/*~PROTOEND~ M_FIELD_COMBO */
};

class M_FIELD_LIST: public M_DIALOG_OBJECT{
public:
	class FIELD_LIST *real;
	/*~PROTOBEG~ M_FIELD_LIST */
public:
	M_FIELD_LIST (FIELD_LIST *_real,
		 M_FIELD_LIST *first);
	void addopt (const char *str);
	void addopt (const char *value,
		 const char *verbose);
	/*~PROTOEND~ M_FIELD_LIST */
};

class M_FIELD_COMBO_MANY: public M_DIALOG_OBJECT{
public:
	class FIELD_COMBO_MANY *real;
	/*~PROTOBEG~ M_FIELD_COMBO_MANY */
public:
	M_FIELD_COMBO_MANY (FIELD_COMBO_MANY *_real,
		 M_FIELD_COMBO_MANY *first);
	/*~PROTOEND~ M_FIELD_COMBO_MANY */
};

class M_FIELD_ENUM: public M_DIALOG_OBJECT{
public:
	class FIELD_ENUM *real;
	/*~PROTOBEG~ M_FIELD_ENUM */
public:
	M_FIELD_ENUM (FIELD_ENUM *_real,
		 M_FIELD_ENUM *first);
	void addopt (const char *str);
	void addopt (const char *value,
		 const char *verbose);
	/*~PROTOEND~ M_FIELD_ENUM */
};
class HELP_FILE;
class SSTRING;
class SSTRINGS;


class M_DIALOG{
protected:
	class M_DIALOG_INTERNAL *internal;
	friend class USERACCT_COMNGS;
	class DIALOG *real;
	bool own_real;		// Is this object allowed to delete real
	/*~PROTOBEG~ M_DIALOG */
public:
	M_DIALOG (DIALOG *_real);
protected:
	M_DIALOG (int);
public:
	M_DIALOG (void);
	void addhelp (HELP_FILE&help, const char *title);
	void addwhat (const char *help);
	void delwhat (const char *help);
	MENU_STATUS edit (const char *_title,
		 const char *_intro,
		 HELP_FILE&helpfile);
	MENU_STATUS edit (const char *_title,
		 const char *_intro,
		 HELP_FILE&helpfile,
		 int &nof);
	MENU_STATUS edit (const char *_title,
		 const char *_intro,
		 HELP_FILE&helpfile,
		 int &nof,
		 int but_options);
	MENU_STATUS editmenu (const char *title,
		 const char *prompt,
		 HELP_FILE&helpfile,
		 int &sel,
		 int options);
	const char *getmenustr (int choice);
	int getnb (void);
	void gui_passthrough (int command,
		 const char *args,
		 ...);
	void hide (void);
	void html_body (const char *ctl, ...);
	void html_end (const char *ctl, ...);
	void html_intro (const char *ctl, ...);
	void html_top (const char *ctl, ...);
	void inswhat (const char *help);
	void last_noempty (void);
	void new_menuinfo (const char *prompt1,
		 const char *prompt2);
	void new_menuitem (const SSTRING&prompt1,
		 const SSTRING&prompt2);
	void new_menuitem (const char *icon,
		 const char *prompt1,
		 const char *prompt2);
	void new_menuitem (const char *prompt1,
		 const SSTRING&prompt2);
	void new_menuitem (const char *prompt1,
		 const char *prompt2);
	void new_menuitems (const char *items[],
		 int item_no);
	void new_menuitems (const char *opt[]);
	void new_menuline (const char *icon,
		 const char *prompt1,
		 const char *prompt2,
		 bool may_select);
	void newf_chk (const char *prompt,
		 char &var,
		 const char *title);
	void newf_chkm (const char *prompt,
		 char &var,
		 const char *title[]);
	void newf_chkm_col (const char *prompt,
		 char &var,
		 const char *title[]);
	void newf_chkm_num (const char *prompt,
		 int &var,
		 const int vals[],
		 const char *title[]);
	M_FIELD_COMBO *newf_combo (const char *prompt,
		 SSTRING&str);
	M_FIELD_COMBO_MANY *newf_combo_many (const char *prompt,
		 SSTRING&str);
	void newf_dbl (const char *prompt,
		 double &val,
		 int nbdecimals);
	M_FIELD_ENUM *newf_enum (const char *prompt,
		 int &sel);
	void newf_gauge (const char *prompt,
		 int &val,
		 int range);
	void newf_head (const char *prompt, const char *msg);
	void newf_hexnum (const char *prompt, int &val);
	void newf_info (const char *prompt, const char *str);
	M_FIELD_LIST *newf_list (const char *prompt,
		 SSTRING&str);
	void newf_num (const char *prompt, int &val);
	void newf_octnum (const char *prompt, int &val);
	void newf_pass (const char *prompt, SSTRING&str);
	void newf_radio (const char *prompt,
		 char &var,
		 char instance_val,
		 const char *title);
	void newf_sheet (const char *prompt,
		 const char *titles[],
		 SSTRINGS&tb);
	void newf_slider (const char *prompt,
		 int &val,
		 int minval,
		 int maxval);
	void newf_str (const char *prompt,
		 SSTRING&str,
		 int width);
	void newf_str (const char *prompt,
		 char *str,
		 int maxsiz);
	void newf_str (const char *prompt, SSTRING&str);
	void newf_textarea (const char *prompt,
		 SSTRING&text,
		 int width,
		 int height);
	void newf_title (const char *pad,
		 int level,
		 const char *prompt,
		 const char *msg);
	void newf_title (const char *prompt, const char *msg);
	void newline (void);
	void reload (int no);
	void reload (int start, int end);
	void reload (void);
	void remove_all (void);
	int remove_del (int no);
	void remove_last (int cut);
	void restore (void);
	void save (void);
	void savewhat (const char *help);
	void set_alt_title (const char *_title);
	void set_lastreadonly (void);
	void set_menuitem (int no,
		 const char *prompt1,
		 const char *prompt2);
	void set_readonly (void);
	void setbutinfo (int id,
		 const char *title,
		 const char *icon);
	void setcontext (const char *s);
	void setheight_hint (void);
	void seticon (const char *_icon);
	void setsidetitle (const char *ctl, ...);
	void settype (DIALOG_TYPE type);
	void show (const char *_title,
		 const char *_intro,
		 HELP_FILE&helpfile,
		 int &nof,
		 int but_options);
	int was_modified (void);
	~M_DIALOG (void);
	/*~PROTOEND~ M_DIALOG */
};

class M_DIALOG_RECORDS: public M_DIALOG{
	/*~PROTOBEG~ M_DIALOG_RECORDS */
protected:
	M_DIALOG_RECORDS (int);
public:
	M_DIALOG_RECORDS (void);
	MENU_STATUS editmenu (const char *title,
		 const char *prompt,
		 HELP_FILE&helpfile,
		 int &sel,
		 int options);
	void newf_head (const char *prompt,
		 const char *msg);
	void setkeyformat (HTML_KEY_TYPE key_type);
	/*~PROTOEND~ M_DIALOG_RECORDS */
};

class M_DIALOG_LISTE: public M_DIALOG_RECORDS{
	/*~PROTOBEG~ M_DIALOG_LISTE */
public:
	M_DIALOG_LISTE (void);
	MENU_STATUS editmenu (const char *title,
		 const char *prompt,
		 HELP_FILE&helpfile,
		 int &sel,
		 int options);
	/*~PROTOEND~ M_DIALOG_LISTE */
};

class M_DIALOG_MENU: public M_DIALOG{
	/*~PROTOBEG~ M_DIALOG_MENU */
public:
	M_DIALOG_MENU (void);
	MENU_STATUS editmenu (const char *title,
		 const char *prompt,
		 HELP_FILE&helpfile,
		 int &sel,
		 int options);
	void setmenu (MENU_CONTEXT ctx);
	/*~PROTOEND~ M_DIALOG_MENU */
};

class M_DIALOG_TEXTBOX: public M_DIALOG{
	/*~PROTOBEG~ M_DIALOG_TEXTBOX */
public:
	void newf_text (const char *prompt,
		 const SSTRINGS&tb);
	void newf_text (const char *prompt,
		 const char *buftab);
	/*~PROTOEND~ M_DIALOG_TEXTBOX */
};

class SSTRINGS;
class POPENFD;

#include <dialog.pe>

class PPPONE;
class DAEMON_INTERNAL;
class PROC;
class CONFIG_FILE;

#include <netconf.pe>

#endif

