#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include "misc.h"


/* #Specification: dnsconf / times / display format
	A DNS manage time in seconds. dnsconf display those times
	using the following format, which makes it easier for user:

	#
		d:hh:mm:ss

		d  = number of days
		hh = number of hours
		mm = number of minutes
		ss = number of seconds
	#

	dnsconf also accept user input with the same format except
	that the leftmost components are optionnal. This means that
	the user may enter a huge number (a lot of seconds), or break
	this number is days, hours, ... The input format is
	then

	#
		[[[days:]hours:]minutes:]seconds
	#
	Where the items inside the square brackets are optionnals.

*/
#

PRIVATE void TIMESTR::formatstr()
{
	if (seconds != 0){
		long days = seconds / (24*60*60);
		long remain = seconds % (24*60*60);
		long hours = remain / (60*60);
		remain = seconds % (60*60);
		int minutes = remain / 60;
		int secs = remain % 60;
		char buf[20];
		::sprintf (buf,"%ld:%02ld:%02d:%02d",days,hours,minutes,secs);
		SSTRING::setfrom (buf);
	}else{
		SSTRING::setfrom ("");
	}
}

/*
	Accepte a string of the form [[[days:]hours:]minutes:]seconds
*/
PUBLIC void TIMESTR::setfrom(const char *_str)
{
	long res[8];
	memset (res,0,sizeof(res));
	int nb=4;
	while (isdigit(*_str) && nb < 8){
		res[nb++] = atol(_str);
		while (isdigit(*_str)) _str++;
		if (*_str != ':') break;
		_str++;
	}
	char lastcar = toupper(_str[0]);
	if (lastcar == 'H'){
		res[nb-1] *= 3600L;
	}else if (lastcar == 'D'){
		res[nb-1] *= 24*3600L;
	}else if (lastcar == 'W'){
		res[nb-1] *= 7*24*3600L;
	}
	setfrom (res[nb-4]*24*60*60
		+res[nb-3]*60*60
		+res[nb-2]*60
		+res[nb-1]);
}
PUBLIC void TIMESTR::setfrom(long _seconds)
{
	seconds = _seconds;
	formatstr();
}

PUBLIC void TIMESTR::setfrom(const TIMESTR &s)
{
	setfrom (s.seconds);
}

PUBLIC TIMESTR::TIMESTR (long _seconds)
{
	setfrom (_seconds);
}

PUBLIC TIMESTR::TIMESTR()
{
	setfrom ((long)0);
}

