/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.tjt.text;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;

public class AlphaNumberFormat
extends NumberFormat {
    private boolean upperCaseFormat;
    private static final int RADIX = 26;

    public AlphaNumberFormat(boolean bl) {
        this.upperCaseFormat = bl;
    }

    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.format((long)d, stringBuffer, fieldPosition);
    }

    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        char[] cArray = new char[33];
        int n = 32;
        while (l > 26L) {
            cArray[n--] = (char)(97L + (l - 1L) % 26L);
            l = (l - 1L) / 26L;
        }
        cArray[n] = (char)(97L + l - 1L);
        String string = new String(cArray, n, cArray.length - n);
        if (this.upperCaseFormat) {
            stringBuffer.append(string.toUpperCase());
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Usage: java AlphaNumberSequence true|false number");
            System.exit(0);
        }
        boolean bl = Boolean.valueOf(stringArray[0]);
        long l = Long.parseLong(stringArray[1]);
        AlphaNumberFormat alphaNumberFormat = new AlphaNumberFormat(bl);
        System.out.print("Formated number: ");
        String string = alphaNumberFormat.format(l);
        System.out.println(string);
        System.out.print("Parse number: ");
        long l2 = alphaNumberFormat.parse(string).longValue();
        System.out.println(l2);
        System.out.println(l == l2 ? "Success" : "Failure");
    }

    public Number parse(String string, ParsePosition parsePosition) {
        string = string.toLowerCase();
        int n = string.length();
        long l = 0L;
        int n2 = parsePosition.getIndex();
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < 'a' || c > 'z') break;
            l *= 26L;
            l += (long)(c - 97 + 1);
            ++n2;
        }
        parsePosition.setIndex(n2);
        return new Long(l);
    }
}

