/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.util.List;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.NumberResult;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.XSLObject;
import com.kvisco.xsl.functions.FunctionCall;
import org.w3c.dom.Node;

public class SumFunctionCall
extends FunctionCall {
    public SumFunctionCall() {
        super("sum");
    }

    public double computeSum(NodeSet nodeSet) {
        double d = 0.0;
        int n = 0;
        while (n < nodeSet.size()) {
            d += this.getNodeValue(nodeSet.get(n));
            ++n;
        }
        return d;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        List list = super.getParameterList();
        if (list.size() != 1) {
            throw new InvalidExprException("invalid number of parameters for function: " + this);
        }
        Expr expr = (Expr)list.get(0);
        if (expr != null) {
            ExprResult exprResult = expr.evaluate(node, processorState);
            if (exprResult.getResultType() != 2) {
                throw new InvalidExprException("unexpected result for function: " + this + " a node-set was expected");
            }
            NodeSet nodeSet = (NodeSet)exprResult;
            return new NumberResult(this.computeSum(nodeSet));
        }
        return new NumberResult(Double.NaN);
    }

    private double getNodeValue(Node node) {
        String string = XSLObject.getNodeValue(node);
        double d = 0.0;
        try {
            return Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }
}

