/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.util.List;
import com.kvisco.xsl.BooleanResult;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringExpr;
import com.kvisco.xsl.StringResult;
import com.kvisco.xsl.functions.FunctionCall;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LangFunctionCall
extends FunctionCall {
    public LangFunctionCall() {
        super("lang");
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        List list = this.getParameterList();
        if (list.size() != 1) {
            throw new InvalidExprException("invalid number of parameters for function: " + this);
        }
        Expr expr = (Expr)list.get(0);
        StringResult stringResult = StringExpr.toStringResult(expr.evaluate(node, processorState));
        String string = stringResult.toString();
        String string2 = this.getLangAttr(node);
        if (string2 == null) {
            return BooleanResult.FALSE_RESULT;
        }
        if (string2.equalsIgnoreCase(string)) {
            return BooleanResult.TRUE_RESULT;
        }
        int n = string2.indexOf(45);
        if (n >= 0 && (string2 = string2.substring(0, n)).equalsIgnoreCase(string)) {
            return BooleanResult.TRUE_RESULT;
        }
        return BooleanResult.FALSE_RESULT;
    }

    private String getLangAttr(Node node) {
        if (node == null) {
            return null;
        }
        Node node2 = node;
        if (node.getNodeType() != 1) {
            node2 = node.getParentNode();
        }
        String string = null;
        while (node2 != null) {
            if (node2.getNodeType() != 1) break;
            string = ((Element)node2).getAttribute("xml:lang");
            if (string != null && string.length() > 0) {
                return string;
            }
            node2 = node2.getParentNode();
        }
        return string;
    }
}

