/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.net.URIUtils;
import com.kvisco.xml.DOMReader;
import com.kvisco.xml.Whitespace;
import com.kvisco.xml.XMLUtil;
import com.kvisco.xsl.AttributeSet;
import com.kvisco.xsl.CopyOf;
import com.kvisco.xsl.EmptyXSLObject;
import com.kvisco.xsl.Id;
import com.kvisco.xsl.Output;
import com.kvisco.xsl.Param;
import com.kvisco.xsl.ParamVariable;
import com.kvisco.xsl.Selection;
import com.kvisco.xsl.TemplateRule;
import com.kvisco.xsl.ValueOf;
import com.kvisco.xsl.Variable;
import com.kvisco.xsl.XSLCData;
import com.kvisco.xsl.XSLCallTemplate;
import com.kvisco.xsl.XSLException;
import com.kvisco.xsl.XSLIf;
import com.kvisco.xsl.XSLImport;
import com.kvisco.xsl.XSLNumber;
import com.kvisco.xsl.XSLObject;
import com.kvisco.xsl.XSLOtherwise;
import com.kvisco.xsl.XSLScript;
import com.kvisco.xsl.XSLSort;
import com.kvisco.xsl.XSLStylesheet;
import com.kvisco.xsl.XSLText;
import com.kvisco.xsl.XSLUse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XSLReader {
    private static final String _MISSING_DOCUMENT_ELEMENT_ERR = "invalid stylesheet, missing document element.";
    private static final String XSLNS_PREFIX = "xslns-prefix";
    private PrintWriter errorWriter = null;
    private DOMReader domReader = null;
    private Hashtable scriptTypeMap = null;

    public XSLReader() throws Exception {
        Object object;
        Object object2;
        Properties properties = new Properties();
        try {
            object2 = null;
            object = new File("xslp.properties");
            object2 = ((File)object).exists() ? new FileInputStream((File)object) : this.getClass().getResourceAsStream("xslp.properties");
            if (object2 != null) {
                properties.load((InputStream)object2);
            }
        }
        catch (IOException iOException) {}
        object2 = properties.getProperty("dom-package");
        object = null;
        object = object2 != null ? new DOMReader(properties.getProperty((String)object2)) : new DOMReader();
        this.init((DOMReader)object);
    }

    public XSLReader(DOMReader dOMReader) {
        this.init(dOMReader);
    }

    public XSLObject createXSLObject(XSLStylesheet xSLStylesheet, Element element) throws XSLException {
        Object object;
        Object object2;
        Object object3;
        if (element == null) {
            throw new XSLException("null element encountered");
        }
        String string = xSLStylesheet.getXSLNSPrefix();
        XSLObject xSLObject = null;
        String string2 = element.getNodeName();
        String string3 = XMLUtil.getNameSpace(string2);
        short s = 20;
        if (string.equals(string3)) {
            if (string3.length() > 0) {
                string2 = string2.substring(string3.length() + 1);
            }
            s = XSLObject.getTypeFromName(string2);
        }
        boolean bl = true;
        boolean bl2 = true;
        switch (s) {
            case 0: 
            case 1: 
            case 13: {
                xSLObject = new Selection(xSLStylesheet, s);
                break;
            }
            case 4: {
                object3 = element.getAttribute("name");
                xSLObject = new AttributeSet(xSLStylesheet, (String)object3);
                bl = false;
                break;
            }
            case 5: {
                String string4 = element.getAttribute("name");
                xSLObject = new XSLCallTemplate(xSLStylesheet, string4);
                bl2 = true;
                break;
            }
            case 6: {
                object2 = new XSLCData(xSLStylesheet);
                ((XSLCData)object2).appendData(XSLObject.getText(element));
                xSLObject = object2;
                bl = false;
                bl2 = false;
                break;
            }
            case 11: {
                xSLObject = new CopyOf(xSLStylesheet);
                bl2 = false;
                break;
            }
            case 15: {
                xSLObject = new Id(xSLStylesheet);
                break;
            }
            case 16: 
            case 38: {
                xSLObject = new XSLIf(xSLStylesheet);
                break;
            }
            case 17: {
                xSLObject = new XSLImport(xSLStylesheet);
                bl2 = false;
                break;
            }
            case 18: 
            case 29: 
            case 31: {
                xSLObject = new EmptyXSLObject(xSLStylesheet, s);
                bl2 = false;
                break;
            }
            case 23: {
                xSLObject = new XSLNumber(xSLStylesheet);
                break;
            }
            case 24: {
                xSLObject = new XSLOtherwise(xSLStylesheet);
                bl = false;
                break;
            }
            case 25: {
                xSLObject = new Output(xSLStylesheet);
                break;
            }
            case 14: {
                xSLObject = new XSLScript(xSLStylesheet, XSLObject.getText(element));
                bl2 = false;
                break;
            }
            case 40: {
                xSLObject = new XSLScript(xSLStylesheet, XSLObject.getText(element));
                bl2 = false;
                break;
            }
            case 30: {
                xSLObject = new XSLSort(xSLStylesheet);
                bl2 = false;
                break;
            }
            case 33: {
                xSLObject = new TemplateRule(xSLStylesheet);
                break;
            }
            case 34: {
                object = new XSLText(xSLStylesheet);
                ((XSLText)object).appendData(XSLObject.getText(element));
                xSLObject = object;
                bl2 = false;
                bl = false;
                break;
            }
            case 35: {
                xSLObject = new XSLUse(xSLStylesheet);
                bl2 = false;
                break;
            }
            case 36: {
                xSLObject = new ValueOf(xSLStylesheet);
                bl2 = false;
                break;
            }
            case 37: {
                String string5 = element.getAttribute("name");
                Attr attr = element.getAttributeNode("expr");
                xSLObject = new Variable(xSLStylesheet, string5);
                if (attr != null) {
                    xSLObject.setAttribute("expr", attr.getValue());
                }
                bl = false;
                break;
            }
            case 27: {
                String string5 = element.getAttribute("name");
                Attr attr = element.getAttributeNode("expr");
                xSLObject = new ParamVariable(xSLStylesheet, string5);
                if (attr != null) {
                    xSLObject.setAttribute("expr", attr.getValue());
                }
                bl = false;
                break;
            }
            case 26: {
                String string5 = element.getAttribute("name");
                Attr attr = element.getAttributeNode("expr");
                xSLObject = new Param(xSLStylesheet, string5);
                if (attr != null) {
                    xSLObject.setAttribute("expr", attr.getValue());
                }
                bl = false;
                break;
            }
            case 39: {
                bl2 = false;
            }
            case 3: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 22: 
            case 28: {
                xSLObject = new XSLObject(xSLStylesheet, s);
                break;
            }
            default: {
                xSLObject = new XSLObject(xSLStylesheet, 20);
                xSLObject.setTypeName(string2);
            }
        }
        if (bl) {
            xSLObject.copyAttributes(element);
        }
        if (!bl2) {
            return xSLObject;
        }
        object3 = element.getChildNodes();
        int n = 0;
        while (n < object3.getLength()) {
            object2 = object3.item(n);
            switch (object2.getNodeType()) {
                case 1: {
                    try {
                        object = this.createXSLObject(xSLStylesheet, (Element)object2);
                        xSLObject.appendAction((XSLObject)object);
                    }
                    catch (XSLException xSLException) {
                        this.errorWriter.println(xSLException.getMessage());
                    }
                    break;
                }
                case 3: {
                    object = ((Text)object2).getData();
                    boolean bl3 = object2.getPreviousSibling() == null;
                    boolean bl4 = object2.getNextSibling() == null;
                    object = Whitespace.stripSpace((String)object, bl3, bl4);
                    if (((String)object).length() <= 0) break;
                    xSLObject.appendAction(new XSLText(xSLStylesheet, (String)object));
                    break;
                }
                case 4: {
                    object = ((CDATASection)object2).getData();
                    xSLObject.appendAction(new XSLCData(xSLStylesheet, (String)object));
                    break;
                }
            }
            ++n;
        }
        xSLObject.freeUnusedMemory(false);
        return xSLObject;
    }

    private void importStyle(String string, XSLStylesheet xSLStylesheet) throws XSLException {
        if (xSLStylesheet == null) {
            return;
        }
        InputStream inputStream = null;
        if (!xSLStylesheet.isAllowableImport(string = URIUtils.resolveHref(string, xSLStylesheet.getDocumentBase()))) {
            this.errorWriter.println("error including stylesheet: '" + string + "'.");
            this.errorWriter.println(" - Stylesheet already directly or indirectly included.");
            this.errorWriter.println(" - continuing processing without the include.");
            return;
        }
        try {
            inputStream = URIUtils.getInputStream(string, null);
        }
        catch (Exception exception) {
            this.errorWriter.println("error importing stylesheet: '" + string + "'.");
            this.errorWriter.println(" - " + exception.getMessage());
            this.errorWriter.println(" - continuing processing without the import.");
            return;
        }
        XSLStylesheet xSLStylesheet2 = this.readStylesheet(inputStream, string);
        xSLStylesheet.importWithoutVerify(xSLStylesheet2);
    }

    private void importStyle(Document document, XSLStylesheet xSLStylesheet, String string) throws XSLException {
        XSLStylesheet xSLStylesheet2 = this.readStylesheet(document, string);
        xSLStylesheet.importFrom(xSLStylesheet2);
    }

    private void includeStyle(String string, XSLStylesheet xSLStylesheet) throws XSLException {
        if (xSLStylesheet == null) {
            return;
        }
        InputStream inputStream = null;
        if (!xSLStylesheet.isAllowableImport(string = URIUtils.resolveHref(string, xSLStylesheet.getDocumentBase()))) {
            this.errorWriter.println("error including stylesheet: '" + string + "'.");
            this.errorWriter.println(" - Stylesheet already directly or indirectly included.");
            this.errorWriter.println(" - continuing processing without the include.");
            return;
        }
        try {
            inputStream = URIUtils.getInputStream(string, null);
        }
        catch (Exception exception) {
            this.errorWriter.println("error importing stylesheet: '" + string + "'.");
            this.errorWriter.println(" - " + exception.getMessage());
            this.errorWriter.println(" - continuing processing without the import.");
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return;
        }
        XSLStylesheet xSLStylesheet2 = this.readStylesheet(inputStream, string);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        xSLStylesheet.includeFrom(xSLStylesheet2);
    }

    private void init(DOMReader dOMReader) {
        this.domReader = dOMReader;
        this.errorWriter = new PrintWriter(System.out, true);
        this.scriptTypeMap = new Hashtable(3);
        this.scriptTypeMap.put("text/javascript", "ECMAScript");
        this.scriptTypeMap.put("text/ecmascript", "ECMAScript");
        this.scriptTypeMap.put("text/jpython", "JPython");
    }

    private void parseStylesheetElement(Element element, XSLStylesheet xSLStylesheet) throws XSLException {
        String string = xSLStylesheet.getXSLNSPrefix();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                Element element2 = (Element)node;
                String string2 = element2.getNodeName();
                XSLObject xSLObject = this.createXSLObject(xSLStylesheet, element2);
                switch (xSLObject.getType()) {
                    case 4: {
                        xSLStylesheet.addAttributeSet((AttributeSet)xSLObject);
                        break;
                    }
                    case 37: {
                        try {
                            xSLStylesheet.addVariable((Variable)xSLObject);
                        }
                        catch (XSLException xSLException) {
                            this.errorWriter.println(xSLException.getMessage());
                            this.errorWriter.println(" -- processing without variable");
                        }
                        break;
                    }
                    case 17: {
                        XSLImport xSLImport = (XSLImport)xSLObject;
                        try {
                            this.importStyle(xSLImport.getHref(), xSLStylesheet);
                        }
                        catch (XSLException xSLException) {
                            this.errorWriter.println(xSLException.getMessage());
                            this.errorWriter.println(" -- processing without import");
                        }
                        break;
                    }
                    case 18: {
                        String string3 = element2.getAttribute("href");
                        try {
                            this.includeStyle(string3, xSLStylesheet);
                        }
                        catch (XSLException xSLException) {
                            this.errorWriter.println(xSLException);
                            this.errorWriter.println(" -- processing without include");
                        }
                        break;
                    }
                    case 15: {
                        xSLStylesheet.addId((Id)xSLObject);
                        break;
                    }
                    case 25: {
                        xSLStylesheet.appendAction(xSLObject);
                        break;
                    }
                    case 29: 
                    case 31: {
                        xSLStylesheet.appendAction(xSLObject);
                        break;
                    }
                    case 33: {
                        xSLStylesheet.addTemplate((TemplateRule)xSLObject);
                        break;
                    }
                    case 40: {
                        xSLStylesheet.addScript((XSLScript)xSLObject);
                        break;
                    }
                }
            }
            ++n;
        }
    }

    public XSLStylesheet readStylesheet(InputStream inputStream, String string) throws XSLException {
        XSLStylesheet xSLStylesheet = null;
        String string2 = string;
        if (inputStream != null) {
            if (string2 == null) {
                string2 = "XSL InputStream";
            }
            Document document = this.domReader.readDocument(inputStream, string2, false, this.errorWriter);
            xSLStylesheet = this.readStylesheet(document, string);
        }
        return xSLStylesheet;
    }

    public XSLStylesheet readStylesheet(String string) throws XSLException {
        XSLStylesheet xSLStylesheet;
        block12: {
            block13: {
                xSLStylesheet = null;
                if (string == null) break block13;
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = URIUtils.getInputStream(string, null);
                        xSLStylesheet = this.readStylesheet(inputStream, string);
                    }
                    catch (Exception exception) {
                        this.errorWriter.println(exception.getMessage());
                        XSLStylesheet xSLStylesheet2 = new XSLStylesheet();
                        Object var6_6 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        return xSLStylesheet2;
                    }
                    Object var6_7 = null;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block12;
                }
                catch (IOException iOException) {}
                break block12;
            }
            xSLStylesheet = new XSLStylesheet();
        }
        return xSLStylesheet;
    }

    public XSLStylesheet readStylesheet(Document document, String string) throws XSLException {
        XSLStylesheet xSLStylesheet = new XSLStylesheet();
        xSLStylesheet.setHref(string);
        xSLStylesheet.setDocumentBase(URIUtils.getDocumentBase(string));
        if (document == null) {
            return xSLStylesheet;
        }
        NodeList nodeList = document.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 7) {
                xSLStylesheet.addPI((ProcessingInstruction)node);
            }
            ++n;
        }
        Element element = document.getDocumentElement();
        if (element == null) {
            throw new XSLException(_MISSING_DOCUMENT_ELEMENT_ERR);
        }
        xSLStylesheet.copyAttributes(element);
        String string2 = element.getNodeName();
        String string3 = XMLUtil.getNameSpace(string2);
        if (!xSLStylesheet.getXSLNSPrefix().equals(string3)) {
            throw new XSLException("Invalid stylesheet. root element must be 'stylesheet' element belonging to the XSL Namespace.");
        }
        if (!"stylesheet".equals(string2 = XMLUtil.getLocalPart(string2)) && !"transform".equals(string2)) {
            throw new XSLException("Invalid stylesheet. missing root 'stylesheet' or 'transform' element.");
        }
        this.parseStylesheetElement(element, xSLStylesheet);
        return xSLStylesheet;
    }

    public void setErrorStream(PrintStream printStream) {
        this.errorWriter = new PrintWriter(printStream, true);
    }

    public void setErrorStream(Writer writer) {
        this.errorWriter = new PrintWriter(writer, true);
    }
}

