/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p.publishers;

import java.io.IOException;
import org.openxml.x3p.publishers.HTMLEntities;
import org.openxml.x3p.publishers.StreamPublisher;
import org.openxml.x3p.publishers.StreamPublisherTarget;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLParagraphElement;
import org.w3c.dom.html.HTMLPreElement;
import org.w3c.dom.html.HTMLScriptElement;
import org.w3c.dom.html.HTMLStyleElement;

public final class HTMLStreamPublisher
extends StreamPublisher {
    HTMLStreamPublisher(StreamPublisherTarget streamPublisherTarget) throws IOException {
        super(streamPublisherTarget);
    }

    protected String getCharacterRef(char c) {
        return HTMLEntities.fromChar(c);
    }

    protected void printElement(Element element, StringBuffer stringBuffer, boolean bl) throws IOException {
        stringBuffer.append("<").append(element.getTagName());
        this.printPart(stringBuffer);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Attr attr = (Attr)namedNodeMap.item(n);
            this.printSpace();
            stringBuffer.setLength(0);
            stringBuffer.append(attr.getName());
            if (attr.getValue() != null) {
                stringBuffer.append("=\"");
                stringBuffer.append(this.encode(attr.getValue(), true));
                stringBuffer.append('\"');
            }
            this.printPart(stringBuffer);
            ++n;
        }
        this.printPart(">");
        if (element.hasChildNodes() || HTMLEntities.supportsChildren(element.getTagName())) {
            this.indent();
            boolean bl2 = false;
            if (element instanceof HTMLScriptElement || element instanceof HTMLStyleElement) {
                bl = true;
                if (this.getFormat().isPretty()) {
                    this.breakLine();
                    bl2 = true;
                }
                Node node = element.getFirstChild();
                while (node != null) {
                    if (node instanceof CharacterData) {
                        this.printPart(((CharacterData)node).getData());
                    }
                    node = node.getNextSibling();
                }
            } else {
                if (element instanceof HTMLPreElement) {
                    bl = true;
                }
                Node node = element.getFirstChild();
                while (node != null) {
                    if (this.getFormat().isPretty() && node instanceof Element && node.hasChildNodes()) {
                        this.breakLine();
                        bl2 = true;
                    }
                    if (this.printNode(node, bl)) {
                        bl2 = true;
                    }
                    node = node.getNextSibling();
                }
            }
            stringBuffer.setLength(0);
            this.unindent();
            if (bl2) {
                this.breakLine();
            }
            stringBuffer.append("</").append(element.getTagName()).append('>');
            this.printPart(stringBuffer);
            if (this.getFormat().isPretty()) {
                this.breakLine();
            }
        } else if (this.getFormat().isPretty() && element instanceof HTMLParagraphElement) {
            this.breakLine();
        }
    }

    public synchronized void publish(Document document) throws IOException {
        this.printPart("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0//EN\"");
        this.breakLine();
        this.printPart("                      \"http://www.w3.org/TR/REC-html40/strict.dtd\">");
        this.breakLine();
        this.publish((Node)document);
        this.flush();
    }
}

