package com.jtauber.fop.apps;

// FOP
import com.jtauber.fop.fo.FOTreeBuilder;
import com.jtauber.fop.render.Renderer;

// DOM
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Attr;

// SAX
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

// Java
import java.io.PrintWriter;

/**
 * A FOProcessor that takes a DOM Document, walks the tree, firing
 * events as if a SAX parser.
 *
 * Instantiate this class with a DOM Document and then run the format
 * method with a PrintWriter the PDF is to be given to.
 */
public class DOMProcessor extends FOProcessor {
    // based on John Cowan's work

    /** the DOM document */
    protected Document document;

    /**
     * create a DOM-driven FOProcessor with default renderer
     *
     * @param document the DOM document
     */
    public DOMProcessor(Document document) {
	super(); // set up the FOProcessor
	this.document = document;
    }

    /**
     * create a DOM-driver FOProcessor
     *
     * @param document the DOM document
     * @param renderer the renderer to use
     */
    public DOMProcessor(Document document, Renderer renderer) {
	super(renderer);
	this.document = document;
    }

    /**
     * Format the document and render
     *
     * @param writer the PrintWriter to render to
     */
    public void format(PrintWriter writer) throws FOPException {

	/* most of this code is modified from John Cowan's */

	Node currentNode;
	AttributeListImpl currentAtts;
	
	/* temporary array for making Strings into character arrays */
	char[] array = null;

	currentAtts = new AttributeListImpl();
	
	/* start at the document element */
	currentNode = this.document;

	try {
	    while (currentNode != null) {
		switch (currentNode.getNodeType()) {
		case Node.DOCUMENT_NODE:
		    this.treeBuilder.startDocument();
		    break;
		case Node.CDATA_SECTION_NODE:
		case Node.TEXT_NODE:
		    String data = currentNode.getNodeValue();
		    int datalen = data.length();
		    if (array == null || array.length < datalen) {
			/* if the array isn't big enough, make a new
			   one */
			array = new char[datalen];
		    }
		    data.getChars(0, datalen, array, 0);
		    this.treeBuilder.characters(array, 0, datalen);
		    break;
		case Node.PROCESSING_INSTRUCTION_NODE:
		    this.treeBuilder.processingInstruction(
	  	        currentNode.getNodeName(),
			currentNode.getNodeValue());
		    break;
		case Node.ELEMENT_NODE:
		    NamedNodeMap map = currentNode.getAttributes();
		    currentAtts.clear();
		    for (int i = map.getLength() - 1; i >= 0; i--) {
			Attr att = (Attr)(map.item(i));
			currentAtts.addAttribute(att.getName(),
						 "CDATA",
						 att.getValue()); 
		    }
		    this.treeBuilder.startElement(
			currentNode.getNodeName(), currentAtts);
		    break;
		}
		
		Node nextNode = currentNode.getFirstChild();
		if (nextNode != null) {
		    currentNode = nextNode;
		    continue;
		}
		
		while (currentNode != null) {
		    switch (currentNode.getNodeType()) {
		    case Node.DOCUMENT_NODE:
			this.treeBuilder.endDocument();
			break;
		    case Node.ELEMENT_NODE:
			this.treeBuilder.endElement(
			    currentNode.getNodeName());
			break;
		    }
		    
		    nextNode = currentNode.getNextSibling();
		    if (nextNode != null) {
			currentNode = nextNode;
			break;
		    }
		    
		    currentNode = currentNode.getParentNode();
		}
	    }
	} catch (SAXException e) {
	    throw new FOPException(e.getMessage());
	}
	layoutput(writer);
    }
}
